/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.service;

import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.service.ContributionListener;
import org.apache.tuscany.sca.contribution.service.ContributionListenerExtensionPoint;
import org.apache.tuscany.sca.contribution.service.ContributionRepository;

public class ExtensibleContributionListener
implements ContributionListener {
    private final ContributionListenerExtensionPoint listeners;

    public ExtensibleContributionListener(ContributionListenerExtensionPoint listeners) {
        this.listeners = listeners;
    }

    public void contributionAdded(ContributionRepository repository, Contribution contribution) {
        for (ContributionListener listener : this.listeners.getContributionListeners()) {
            try {
                listener.contributionAdded(repository, contribution);
            }
            catch (Exception e) {}
        }
    }

    public void contributionRemoved(ContributionRepository repository, Contribution contribution) {
        for (ContributionListener listener : this.listeners.getContributionListeners()) {
            try {
                listener.contributionRemoved(repository, contribution);
            }
            catch (Exception e) {}
        }
    }

    public void contributionUpdated(ContributionRepository repository, Contribution oldContribution, Contribution contribution) {
        for (ContributionListener listener : this.listeners.getContributionListeners()) {
            try {
                listener.contributionUpdated(repository, oldContribution, contribution);
            }
            catch (Exception e) {}
        }
    }
}

