/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.resource.impl;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.builder.impl.ProblemImpl;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.resource.ResourceExport;
import org.apache.tuscany.sca.contribution.resource.ResourceImportExportFactory;
import org.apache.tuscany.sca.contribution.resource.impl.ResourceExportModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceExportProcessor
implements StAXArtifactProcessor<ResourceExport> {
    private static final String SCA10_NS = "http://www.osoa.org/xmlns/sca/1.0";
    private static final QName EXPORT_RESOURCE = new QName("http://www.osoa.org/xmlns/sca/1.0", "export.resource");
    private static final String URI = "uri";
    private final ResourceImportExportFactory factory;
    private final Monitor monitor;

    public ResourceExportProcessor(ModelFactoryExtensionPoint modelFactories, Monitor monitor) {
        this.factory = (ResourceImportExportFactory)modelFactories.getFactory(ResourceImportExportFactory.class);
        this.monitor = monitor;
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "contribution-resource-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem((Problem)problem);
        }
    }

    public QName getArtifactType() {
        return EXPORT_RESOURCE;
    }

    public Class<ResourceExport> getModelType() {
        return ResourceExport.class;
    }

    public ResourceExport read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        ResourceExport resourceExport = this.factory.createResourceExport();
        QName element = null;
        while (reader.hasNext()) {
            int event = reader.getEventType();
            switch (event) {
                case 1: {
                    element = reader.getName();
                    if (!EXPORT_RESOURCE.equals(element)) break;
                    String uri = reader.getAttributeValue(null, URI);
                    if (uri == null) {
                        this.error("AttributeURIMissing", reader, new Object[0]);
                        break;
                    }
                    resourceExport.setURI(uri);
                    break;
                }
                case 2: {
                    if (!EXPORT_RESOURCE.equals(reader.getName())) break;
                    return resourceExport;
                }
            }
            if (!reader.hasNext()) continue;
            reader.next();
        }
        return resourceExport;
    }

    public void write(ResourceExport resourceExport, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        writer.writeStartElement(EXPORT_RESOURCE.getNamespaceURI(), EXPORT_RESOURCE.getLocalPart());
        if (resourceExport.getURI() != null) {
            writer.writeAttribute(URI, resourceExport.getURI());
        }
        writer.writeEndElement();
    }

    public void resolve(ResourceExport resourceExport, ModelResolver resolver) throws ContributionResolveException {
        if (resourceExport.getURI() != null) {
            resourceExport.setModelResolver(new ResourceExportModelResolver(resourceExport, resolver));
        }
    }
}

