/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.java.impl;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.Import;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.java.JavaImport;
import org.apache.tuscany.sca.contribution.java.impl.ContributionHelper;
import org.apache.tuscany.sca.contribution.resolver.ClassReference;
import org.apache.tuscany.sca.contribution.resolver.DefaultDelegatingModelResolver;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.extensibility.ServiceDiscovery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderModelResolver
extends URLClassLoader
implements ModelResolver {
    private Contribution contribution;
    private Map<String, ModelResolver> importResolvers = new HashMap<String, ModelResolver>();

    private static ClassLoader parentClassLoader() {
        ClassLoader parentClassLoader = ServiceDiscovery.getInstance().getServiceDiscoverer().getClass().getClassLoader();
        return parentClassLoader;
    }

    private static URL[] getContributionURLs(Contribution contribution) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(new URL(contribution.getLocation()));
        urls.addAll(ContributionHelper.getNestedJarUrls(contribution));
        return urls.toArray(new URL[urls.size()]);
    }

    public ClassLoaderModelResolver(Contribution contribution, ModelFactoryExtensionPoint modelFactories) throws IOException {
        super(ClassLoaderModelResolver.getContributionURLs(contribution), ClassLoaderModelResolver.parentClassLoader());
        this.contribution = contribution;
        HashMap<String, ArrayList<ModelResolver>> resolverMap = new HashMap<String, ArrayList<ModelResolver>>();
        for (Import import_ : this.contribution.getImports()) {
            if (!(import_ instanceof JavaImport)) continue;
            JavaImport javaImport = (JavaImport)import_;
            ArrayList<ModelResolver> resolvers = (ArrayList<ModelResolver>)resolverMap.get(javaImport.getPackage());
            if (resolvers == null) {
                resolvers = new ArrayList<ModelResolver>();
                resolverMap.put(javaImport.getPackage(), resolvers);
            }
            resolvers.add(javaImport.getModelResolver());
        }
        for (Map.Entry entry : resolverMap.entrySet()) {
            this.importResolvers.put((String)entry.getKey(), (ModelResolver)new DefaultDelegatingModelResolver((List)entry.getValue()));
        }
    }

    public void addModel(Object resolved) {
        throw new IllegalStateException();
    }

    public Object removeModel(Object resolved) {
        throw new IllegalStateException();
    }

    public <T> T resolveModel(Class<T> modelClass, T unresolved) {
        if (!(unresolved instanceof ClassReference)) {
            return unresolved;
        }
        try {
            String className = ((ClassReference)unresolved).getClassName();
            Class<?> clazz = Class.forName(className, true, this);
            return modelClass.cast(new ClassReference(clazz));
        }
        catch (ClassNotFoundException e) {
            return unresolved;
        }
        catch (NoClassDefFoundError e) {
            return unresolved;
        }
    }

    @Override
    public URL findResource(String name) {
        URL url = super.findResource(name);
        return url;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        Enumeration<URL> resources = super.findResources(name);
        ArrayList<URL> allResources = new ArrayList<URL>();
        while (resources.hasMoreElements()) {
            allResources.add(resources.nextElement());
        }
        return Collections.enumeration(allResources);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        ClassReference classReference;
        int d = name.lastIndexOf(46);
        String packageName = d != -1 ? name.substring(0, d) : null;
        ModelResolver importResolver = this.importResolvers.get(packageName);
        if (importResolver != null && !(classReference = (ClassReference)importResolver.resolveModel(ClassReference.class, (Object)new ClassReference(name))).isUnresolved()) {
            return classReference.getJavaClass();
        }
        Class<?> clazz = super.findClass(name);
        return clazz;
    }
}

