/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.java;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.java.ContributionClassLoaderProvider;
import org.apache.tuscany.sca.contribution.java.ContributionClassloaderProviderExtensionPoint;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.extensibility.ServiceDiscovery;

public class DefaultContributionClassloaderProviderExtensionPoint
implements ContributionClassloaderProviderExtensionPoint {
    private HashMap<String, ContributionClassLoaderProvider> providers = new HashMap();
    private boolean loaded;

    public void addProvider(ContributionClassLoaderProvider provider) {
        this.providers.put(provider.getContributionType(), provider);
    }

    public void removeProvider(ContributionClassLoaderProvider provider) {
        this.providers.remove(provider.getContributionType());
    }

    public ContributionClassLoaderProvider getProvider(String contributionType) {
        this.loadProviders();
        return this.providers.get(contributionType);
    }

    private synchronized void loadProviders() {
        Set processorDeclarations;
        if (this.loaded) {
            return;
        }
        try {
            processorDeclarations = ServiceDiscovery.getInstance().getServiceDeclarations(ContributionClassLoaderProvider.class);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        for (ServiceDeclaration processorDeclaration : processorDeclarations) {
            Map attributes = processorDeclaration.getAttributes();
            String contributionType = (String)attributes.get("type");
            LazyContributionClassLoaderProvider provider = new LazyContributionClassLoaderProvider(contributionType, processorDeclaration);
            this.addProvider(provider);
        }
        this.loaded = true;
    }

    private static class LazyContributionClassLoaderProvider
    implements ContributionClassLoaderProvider {
        private ServiceDeclaration processorDeclaration;
        private String contributionType;
        private ContributionClassLoaderProvider provider;

        private LazyContributionClassLoaderProvider(String contributionType, ServiceDeclaration processorDeclaration) {
            this.processorDeclaration = processorDeclaration;
            this.contributionType = contributionType;
        }

        public String getContributionType() {
            return this.contributionType;
        }

        public ClassLoader getClassLoader(Contribution contribution, ClassLoader parent) {
            if (this.provider == null) {
                try {
                    Class providerClass = this.processorDeclaration.loadClass();
                    Constructor constructor = providerClass.getConstructor(new Class[0]);
                    this.provider = (ContributionClassLoaderProvider)constructor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            return this.provider.getClassLoader(contribution, parent);
        }
    }
}

