/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.common.xml.stax.impl;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class XMLStreamSerializer
implements XMLStreamConstants {
    public static final String NAMESPACE_PREFIX = "ns";
    private static int namespaceSuffix;
    private int depth;
    private boolean isRepairingNamespaces = true;

    public XMLStreamSerializer(boolean isRepairingNamespaces) {
        this.isRepairingNamespaces = isRepairingNamespaces;
    }

    public XMLStreamSerializer() {
        this(true);
    }

    private String generateUniquePrefix(NamespaceContext nsCtxt) {
        String prefix = NAMESPACE_PREFIX + namespaceSuffix++;
        while (nsCtxt.getNamespaceURI(prefix) != null) {
            prefix = NAMESPACE_PREFIX + namespaceSuffix++;
        }
        return prefix;
    }

    public void serialize(XMLStreamReader node, XMLStreamWriter writer) throws XMLStreamException {
        this.serializeNode(node, writer);
    }

    protected void serializeAttributes(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            String prefix = reader.getAttributePrefix(i);
            String namespaceName = reader.getAttributeNamespace(i);
            String localName = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            this.writeAttribute(writer, prefix, localName, namespaceName, value);
        }
    }

    public void writeAttribute(XMLStreamWriter writer, QName name, String value) throws XMLStreamException {
        this.writeAttribute(writer, name.getPrefix(), name.getLocalPart(), name.getNamespaceURI(), value);
    }

    public String writeAttribute(XMLStreamWriter writer, String prefix, String localName, String namespaceURI, String value) throws XMLStreamException {
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        if (prefix == null) {
            prefix = "";
        }
        if (this.isRepairingNamespaces) {
            writer.writeAttribute(prefix, namespaceURI, localName, value);
            return writer.getPrefix(namespaceURI);
        }
        String writerPrefix = writer.getPrefix(namespaceURI);
        if (!"".equals(namespaceURI)) {
            if (writerPrefix != null && this.isDefaultNSPrefix(prefix)) {
                writer.writeAttribute(writerPrefix, namespaceURI, localName, value);
                return writerPrefix;
            }
            if (!this.isDefaultNSPrefix(prefix) && !prefix.equals(writerPrefix)) {
                writer.writeNamespace(prefix, namespaceURI);
                writer.writeAttribute(prefix, namespaceURI, localName, value);
                return prefix;
            }
            if (this.isDefaultNSPrefix(prefix)) {
                prefix = this.generateUniquePrefix(writer.getNamespaceContext());
                writer.writeNamespace(prefix, namespaceURI);
                writer.writeAttribute(prefix, namespaceURI, localName, value);
                return prefix;
            }
            writer.writeAttribute(prefix, namespaceURI, localName, value);
            return prefix;
        }
        writer.writeAttribute(localName, value);
        return prefix;
    }

    private boolean isDefaultNSPrefix(String prefix) {
        return prefix == null || prefix.equals("");
    }

    protected void serializeCData(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeCData(reader.getText());
    }

    protected void serializeComment(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeComment(reader.getText());
    }

    protected void serializeElement(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        this.writeStartElement(writer, reader.getName());
        int count = reader.getNamespaceCount();
        for (int i = 0; i < count; ++i) {
            String namespacePrefix = reader.getNamespacePrefix(i);
            this.serializeNamespace(namespacePrefix, reader.getNamespaceURI(i), writer);
        }
        this.serializeAttributes(reader, writer);
    }

    public void writeStartElement(XMLStreamWriter writer, QName name) throws XMLStreamException {
        this.writeStartElement(writer, name.getPrefix(), name.getLocalPart(), name.getNamespaceURI());
    }

    public void writeStartElement(XMLStreamWriter writer, String prefix, String localName, String namespaceURI) throws XMLStreamException {
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        if (prefix == null) {
            prefix = "";
        }
        if (this.isRepairingNamespaces) {
            writer.writeStartElement(prefix, localName, namespaceURI);
            return;
        }
        String writerPrefix = writer.getPrefix(namespaceURI);
        if (writerPrefix != null) {
            writer.writeStartElement(writerPrefix, localName, namespaceURI);
        } else if ("".equals(namespaceURI)) {
            writer.writeStartElement(localName);
            String defaultNS = writer.getNamespaceContext().getNamespaceURI("");
            if (defaultNS != null && !"".equals(defaultNS)) {
                writer.writeNamespace(prefix, namespaceURI);
            }
        } else {
            writer.writeStartElement(prefix, localName, namespaceURI);
            writer.writeNamespace(prefix, namespaceURI);
        }
    }

    protected void serializeEndElement(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeEndElement();
    }

    private void serializeNamespace(String prefix, String uri, XMLStreamWriter writer) throws XMLStreamException {
        this.writeNamespace(writer, prefix, uri);
    }

    public String writeNamespace(XMLStreamWriter writer, String prefix, String uri) throws XMLStreamException {
        String prefix1;
        if (uri == null) {
            uri = "";
        }
        if ((prefix1 = writer.getPrefix(uri)) == null) {
            String ns;
            if (prefix == null) {
                prefix = "";
            }
            if ("".equals(prefix) && !"".equals(uri) && (ns = writer.getNamespaceContext().getNamespaceURI(prefix)) != null) {
                prefix = this.generateUniquePrefix(writer.getNamespaceContext());
            }
            writer.writeNamespace(prefix, uri);
            return prefix;
        }
        return prefix1;
    }

    protected void serializeNode(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        while (true) {
            int event;
            if ((event = reader.getEventType()) == 1) {
                this.serializeElement(reader, writer);
                ++this.depth;
            } else if (event == 10) {
                this.serializeAttributes(reader, writer);
            } else if (event == 4) {
                this.serializeText(reader, writer);
            } else if (event == 5) {
                this.serializeComment(reader, writer);
            } else if (event == 12) {
                this.serializeCData(reader, writer);
            } else if (event == 2) {
                this.serializeEndElement(writer);
                --this.depth;
            } else if (event == 7) {
                ++this.depth;
                writer.writeStartDocument();
            } else if (event == 8) {
                if (this.depth != 0) {
                    --this.depth;
                }
                writer.writeEndDocument();
            }
            if (this.depth == 0 || !reader.hasNext()) break;
            reader.next();
        }
    }

    protected void serializeText(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeCharacters(reader.getText());
    }
}

