/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.Extensible;
import org.apache.tuscany.sca.assembly.Extension;
import org.apache.tuscany.sca.assembly.OperationSelector;
import org.apache.tuscany.sca.assembly.WireFormat;
import org.apache.tuscany.sca.binding.ws.WebServiceBinding;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLDefinition;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterface;
import org.apache.tuscany.sca.policy.DefaultIntent;
import org.apache.tuscany.sca.policy.DefaultingPolicySubject;
import org.apache.tuscany.sca.policy.ExtensionType;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.PolicySet;
import org.w3c.dom.Element;

class WebServiceBindingImpl
implements WebServiceBinding,
DefaultingPolicySubject,
Extensible {
    private String name;
    private String uri;
    private boolean unresolved;
    private List<Object> extensions = new ArrayList<Object>();
    private List<Extension> attributeExtensions = new ArrayList<Extension>();
    private List<DefaultIntent> defaultIntents = new ArrayList<DefaultIntent>();
    private List<Intent> requiredIntents = new ArrayList<Intent>();
    private List<PolicySet> policySets = new ArrayList<PolicySet>();
    private ExtensionType extensionType;
    private String location;
    private Binding binding;
    private Service service;
    private Port port;
    private Port endpoint;
    private QName bindingName;
    private String portName;
    private QName serviceName;
    private String endpointName;
    private InterfaceContract bindingInterfaceContract;
    private Element endPointReference;
    private String wsdlNamespace;
    private WSDLDefinition userSpecifiedWSDLDefinition;
    private Definition generatedWSDLDocument;
    private boolean isDocumentStyle;
    private boolean isLiteralEncoding;
    private boolean isMessageWrapped;
    private Map<String, String> wsdliLocations = new HashMap<String, String>();
    private String userSpecifiedUri;

    protected WebServiceBindingImpl() {
    }

    public String toString() {
        return "Web Service Binding: " + this.name;
    }

    public String getName() {
        return this.name;
    }

    public String getURI() {
        return this.uri;
    }

    @Override
    public String getUserSpecifiedURI() {
        return this.userSpecifiedUri;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setURI(String uri) {
        this.uri = uri;
        if (uri == null) {
            this.setUserSpecifiedURI(null);
        }
    }

    @Override
    public void setUserSpecifiedURI(String uri) {
        this.userSpecifiedUri = uri;
    }

    @Override
    public boolean isUnresolved() {
        return this.unresolved;
    }

    @Override
    public void setUnresolved(boolean unresolved) {
        this.unresolved = unresolved;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public List<Object> getExtensions() {
        return this.extensions;
    }

    public List<Extension> getAttributeExtensions() {
        return this.attributeExtensions;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(String location) {
        this.location = location;
    }

    @Override
    public Binding getBinding() {
        if (this.binding == null && this.getUserSpecifiedWSDLDefinition() != null && this.userSpecifiedWSDLDefinition.getBinding() != null) {
            this.binding = this.userSpecifiedWSDLDefinition.getBinding();
            this.determineWSDLCharacteristics();
        }
        return this.binding;
    }

    @Override
    public QName getBindingName() {
        if (this.isUnresolved()) {
            return this.bindingName;
        }
        if (this.binding != null) {
            return this.binding.getQName();
        }
        return null;
    }

    @Override
    public String getEndpointName() {
        if (this.isUnresolved()) {
            return this.endpointName;
        }
        if (this.endpoint != null) {
            return this.endpoint.getName();
        }
        return null;
    }

    @Override
    public Port getEndpoint() {
        return this.endpoint;
    }

    @Override
    public Port getPort() {
        return this.port;
    }

    @Override
    public String getPortName() {
        if (this.isUnresolved()) {
            return this.portName;
        }
        if (this.port != null) {
            return this.port.getName();
        }
        return null;
    }

    @Override
    public Service getService() {
        return this.service;
    }

    @Override
    public QName getServiceName() {
        if (this.isUnresolved()) {
            return this.serviceName;
        }
        if (this.service != null) {
            return this.service.getQName();
        }
        return null;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
        this.determineWSDLCharacteristics();
    }

    @Override
    public void setBindingName(QName bindingName) {
        if (!this.isUnresolved()) {
            throw new IllegalStateException();
        }
        this.bindingName = bindingName;
    }

    @Override
    public void setEndpoint(Port endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public void setEndpointName(String endpointName) {
        if (!this.isUnresolved()) {
            throw new IllegalStateException();
        }
        this.endpointName = endpointName;
    }

    @Override
    public void setPort(Port port) {
        this.port = port;
    }

    @Override
    public void setPortName(String portName) {
        if (!this.isUnresolved()) {
            throw new IllegalStateException();
        }
        this.portName = portName;
    }

    @Override
    public void setService(Service service) {
        this.service = service;
    }

    @Override
    public void setServiceName(QName serviceName) {
        if (!this.isUnresolved()) {
            throw new IllegalStateException();
        }
        this.serviceName = serviceName;
    }

    @Override
    public WSDLDefinition getUserSpecifiedWSDLDefinition() {
        Interface iface;
        if (this.userSpecifiedWSDLDefinition == null && (iface = this.bindingInterfaceContract.getInterface()) instanceof WSDLInterface) {
            this.userSpecifiedWSDLDefinition = ((WSDLInterface)iface).getWsdlDefinition();
        }
        return this.userSpecifiedWSDLDefinition;
    }

    @Override
    public void setUserSpecifiedWSDLDefinition(WSDLDefinition wsdlDefinition) {
        this.userSpecifiedWSDLDefinition = wsdlDefinition;
    }

    @Override
    public String getNamespace() {
        return this.wsdlNamespace;
    }

    @Override
    public void setNamespace(String namespace) {
        this.wsdlNamespace = namespace;
    }

    @Override
    public InterfaceContract getBindingInterfaceContract() {
        return this.bindingInterfaceContract;
    }

    @Override
    public void setBindingInterfaceContract(InterfaceContract bindingInterfaceContract) {
        this.bindingInterfaceContract = bindingInterfaceContract;
    }

    public List<PolicySet> getPolicySets() {
        return this.policySets;
    }

    public List<Intent> getRequiredIntents() {
        return this.requiredIntents;
    }

    public ExtensionType getExtensionType() {
        return this.extensionType;
    }

    public void setExtensionType(ExtensionType intentAttachPointType) {
        this.extensionType = intentAttachPointType;
    }

    @Override
    public Element getEndPointReference() {
        return this.endPointReference;
    }

    @Override
    public void setEndPointReference(Element epr) {
        this.endPointReference = epr;
    }

    @Override
    public Definition getGeneratedWSDLDocument() {
        return this.generatedWSDLDocument;
    }

    @Override
    public void setGeneratedWSDLDocument(Definition definition) {
        this.generatedWSDLDocument = definition;
        this.determineWSDLCharacteristics();
    }

    public QName getType() {
        return TYPE;
    }

    public WireFormat getRequestWireFormat() {
        return null;
    }

    public void setRequestWireFormat(WireFormat wireFormat) {
    }

    public WireFormat getResponseWireFormat() {
        return null;
    }

    public void setResponseWireFormat(WireFormat wireFormat) {
    }

    public OperationSelector getOperationSelector() {
        return null;
    }

    public void setOperationSelector(OperationSelector operationSelector) {
    }

    protected void determineWSDLCharacteristics() {
        this.setIsDocumentStyle();
        this.setIsLiteralEncoding();
        this.setIsMessageWrapped();
    }

    protected void setIsDocumentStyle() {
        if (this.binding == null) {
            Message firstMessage;
            Part firstPart;
            if (this.userSpecifiedWSDLDefinition != null && this.userSpecifiedWSDLDefinition.getDefinition() != null && (firstPart = (Part)(firstMessage = (Message)this.userSpecifiedWSDLDefinition.getDefinition().getMessages().values().iterator().next()).getParts().values().iterator().next()).getTypeName() != null) {
                this.isDocumentStyle = false;
                return;
            }
            this.isDocumentStyle = true;
            return;
        }
        for (Object ext : this.binding.getExtensibilityElements()) {
            if (!(ext instanceof SOAPBinding)) continue;
            this.isDocumentStyle = !"rpc".equals(((SOAPBinding)ext).getStyle());
            return;
        }
        this.isDocumentStyle = true;
    }

    protected void setIsLiteralEncoding() {
        if (this.binding == null) {
            this.isLiteralEncoding = true;
            return;
        }
        for (Object bop : this.binding.getBindingOperations()) {
            BindingInput bindingInput = ((BindingOperation)bop).getBindingInput();
            if (bindingInput == null) continue;
            for (Object ext : bindingInput.getExtensibilityElements()) {
                if (!(ext instanceof SOAPBody)) continue;
                this.isLiteralEncoding = "literal".equals(((SOAPBody)ext).getUse());
                return;
            }
        }
        this.isLiteralEncoding = true;
    }

    protected void setIsMessageWrapped() {
        if (this.getBindingInterfaceContract() != null) {
            this.isMessageWrapped = ((Operation)this.getBindingInterfaceContract().getInterface().getOperations().get(0)).isInputWrapperStyle();
        }
    }

    @Override
    public boolean isRpcEncoded() {
        return !this.isDocumentStyle && !this.isLiteralEncoding;
    }

    @Override
    public boolean isRpcLiteral() {
        return !this.isDocumentStyle && this.isLiteralEncoding;
    }

    @Override
    public boolean isDocEncoded() {
        return this.isDocumentStyle && !this.isLiteralEncoding;
    }

    @Override
    public boolean isDocLiteralUnwrapped() {
        this.setIsMessageWrapped();
        return this.isDocumentStyle && this.isLiteralEncoding && !this.isMessageWrapped;
    }

    @Override
    public boolean isDocLiteralWrapped() {
        this.setIsMessageWrapped();
        return this.isDocumentStyle && this.isLiteralEncoding && this.isMessageWrapped;
    }

    @Override
    public boolean isDocLiteralBare() {
        this.setIsMessageWrapped();
        return this.isDocumentStyle && this.isLiteralEncoding;
    }

    @Override
    public boolean isHTTPTransport() {
        return this.getBindingTransport().equals("http://schemas.xmlsoap.org/soap/http");
    }

    @Override
    public boolean isJMSTransport() {
        return this.getBindingTransport().equals("http://schemas.xmlsoap.org/soap/jms");
    }

    @Override
    public String getBindingTransport() {
        if (this.binding != null) {
            for (Object ext : this.binding.getExtensibilityElements()) {
                if (!(ext instanceof SOAPBinding)) continue;
                return ((SOAPBinding)ext).getTransportURI();
            }
        }
        return "http://schemas.xmlsoap.org/soap/http";
    }

    @Override
    public Map<String, String> getWsdliLocations() {
        return this.wsdliLocations;
    }

    public List<DefaultIntent> getDefaultIntents() {
        return this.defaultIntents;
    }
}

