/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.wsdlgen;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.Contract;
import org.apache.tuscany.sca.assembly.builder.BindingBuilder;
import org.apache.tuscany.sca.assembly.builder.BuilderContext;
import org.apache.tuscany.sca.binding.ws.WebServiceBinding;
import org.apache.tuscany.sca.binding.ws.wsdlgen.BindingWSDLGenerator;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.definitions.Definitions;
import org.apache.tuscany.sca.policy.BindingType;
import org.apache.tuscany.sca.policy.DefaultIntent;
import org.apache.tuscany.sca.policy.DefaultingPolicySubject;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.PolicyFactory;

public class WebServiceBindingBuilder
implements BindingBuilder<WebServiceBinding> {
    private ExtensionPointRegistry extensionPoints;
    private PolicyFactory policyFactory;

    public WebServiceBindingBuilder(ExtensionPointRegistry extensionPoints) {
        this.extensionPoints = extensionPoints;
        FactoryExtensionPoint modelFactories = (FactoryExtensionPoint)extensionPoints.getExtensionPoint(FactoryExtensionPoint.class);
        this.policyFactory = (PolicyFactory)modelFactories.getFactory(PolicyFactory.class);
    }

    public void build(Component component, Contract contract, WebServiceBinding binding, BuilderContext context, boolean rebuild) {
        if (rebuild) {
            binding.setBindingInterfaceContract(null);
            binding.setGeneratedWSDLDocument(null);
        }
        BindingWSDLGenerator.generateWSDL(component, contract, binding, this.extensionPoints, context.getMonitor());
        List defaultIntents = ((DefaultingPolicySubject)binding).getDefaultIntents();
        DefaultIntent defaultIntent = this.policyFactory.createDefaultIntent();
        Definitions systemDefinitions = context.getDefinitions();
        if (systemDefinitions != null) {
            BindingType bindingType = systemDefinitions.getBindingType(binding.getType());
            for (Intent mayProvideIntent : bindingType.getMayProvidedIntents()) {
                if (mayProvideIntent.getName().getLocalPart().equals("SOAP.v1_1")) {
                    defaultIntent.setIntent(mayProvideIntent);
                }
                if (!mayProvideIntent.getName().getLocalPart().equals("SOAP.v1_2")) continue;
                defaultIntent.getMutuallyExclusiveIntents().add(mayProvideIntent);
            }
            defaultIntents.add(defaultIntent);
        }
    }

    public QName getBindingType() {
        return WebServiceBinding.TYPE;
    }
}

