/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jsonrpc.provider;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONObject;

public class JavaToSmd {
    public static String interfaceToSmd(Class<?> klazz, String serviceUrl) {
        try {
            String name = klazz.getSimpleName();
            Method[] methods = klazz.getMethods();
            JSONObject smd = new JSONObject();
            smd.put("SMDVersion", (Object)".1");
            smd.put("objectName", (Object)name);
            smd.put("serviceType", (Object)"JSON-RPC");
            smd.put("serviceURL", (Object)serviceUrl);
            JSONArray services = new JSONArray();
            for (int i = 0; i < methods.length; ++i) {
                JSONObject service = new JSONObject();
                Class<?>[] params = methods[i].getParameterTypes();
                JSONArray paramArray = new JSONArray();
                for (int j = 0; j < params.length; ++j) {
                    JSONObject param = new JSONObject();
                    param.put("name", (Object)("param" + j));
                    param.put("type", (Object)JavaToSmd.getJSONType(params[j]));
                    paramArray.put((Map)param);
                }
                service.put("name", (Object)methods[i].getName());
                service.put("parameters", (Collection)paramArray);
                services.put((Map)service);
            }
            smd.put("methods", (Collection)services);
            return smd.toString(2);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String interfaceToSmd20(Class<?> klazz, String serviceUrl) {
        try {
            String name = klazz.getSimpleName();
            Method[] methods = klazz.getMethods();
            JSONObject smd = new JSONObject();
            smd.put("SMDVersion", (Object)"2.0");
            smd.put("transport", (Object)"POST");
            smd.put("envelope", (Object)"JSON-RPC-1.0");
            smd.put("target", (Object)serviceUrl);
            smd.put("id", (Object)klazz.getName());
            smd.put("description", (Object)("JSON-RPC service provided by Tuscany: " + name));
            JSONObject services = new JSONObject();
            for (int i = 0; i < methods.length; ++i) {
                JSONObject service = new JSONObject();
                Class<?>[] params = methods[i].getParameterTypes();
                JSONArray paramArray = new JSONArray();
                for (int j = 0; j < params.length; ++j) {
                    JSONObject param = new JSONObject();
                    param.put("name", (Object)("param" + j));
                    param.put("type", (Object)JavaToSmd.getJSONType(params[j]));
                    paramArray.put((Map)param);
                }
                service.put("parameters", (Collection)paramArray);
                services.put(methods[i].getName(), (Map)service);
            }
            smd.put("services", (Map)services);
            return smd.toString(2);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static String getJSONType(Class<?> type) {
        if (type == Boolean.TYPE || type == Boolean.class) {
            return "boolean";
        }
        if (type == String.class) {
            return "string";
        }
        if (Byte.TYPE == type || Short.TYPE == type || Integer.TYPE == type || Long.TYPE == type || Float.TYPE == type || Double.TYPE == type || Number.class.isAssignableFrom(type)) {
            return "number";
        }
        if (type.isArray() || Collection.class.isAssignableFrom(type)) {
            return "array";
        }
        return "object";
    }
}

