/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jsonrpc.provider;

import org.apache.http.client.HttpClient;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.binding.jsonrpc.provider.JsonRpcInvoker;
import org.apache.tuscany.sca.host.http.client.HttpClientFactory;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.provider.ReferenceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;

public class JSONRPCReferenceBindingProvider
implements ReferenceBindingProvider {
    private EndpointReference endpointReference;
    private RuntimeComponentReference reference;
    private InterfaceContract referenceContract;
    private HttpClientFactory httpClientFactory;
    private HttpClient httpClient;

    public JSONRPCReferenceBindingProvider(HttpClientFactory httpClientFactory, EndpointReference endpointReference) {
        this.httpClientFactory = httpClientFactory;
        this.endpointReference = endpointReference;
        this.reference = (RuntimeComponentReference)endpointReference.getReference();
    }

    public InterfaceContract getBindingInterfaceContract() {
        return this.reference.getInterfaceContract();
    }

    public Invoker createInvoker(Operation operation) {
        return new JsonRpcInvoker(this.endpointReference, operation, this.httpClient);
    }

    public void start() {
        this.httpClient = this.httpClientFactory.createHttpClient();
    }

    public void stop() {
        if (this.httpClient != null) {
            this.httpClient.getConnectionManager().shutdown();
        }
    }

    public boolean supportsOneWayInvocation() {
        return false;
    }
}

