/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jsonrpc.protocol;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.tuscany.sca.binding.jsonrpc.protocol.JsonRpc20Error;
import org.apache.tuscany.sca.databinding.json.jackson.JacksonHelper;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.ObjectNode;

public abstract class JsonRpcResponse {
    public static final int REMOTE_EXCEPTION = 490;
    protected ObjectNode jsonNode;

    public JsonRpcResponse(ObjectNode response) {
        this.jsonNode = response;
    }

    public JsonRpcResponse(JsonNode id, Throwable t) {
        ObjectNode response = JsonNodeFactory.instance.objectNode();
        response.put("id", id);
        response.put("error", (JsonNode)this.mapError(t));
        this.jsonNode = response;
    }

    public JsonRpcResponse(JsonNode id, JsonNode result) {
        ObjectNode response = JsonNodeFactory.instance.objectNode();
        response.put("id", id);
        response.put("result", result);
        this.jsonNode = response;
    }

    private ObjectNode mapError(Throwable t) {
        ObjectNode obj = JsonNodeFactory.instance.objectNode();
        obj.put("code", 490);
        obj.put("message", t.getMessage());
        ObjectNode exception = JsonNodeFactory.instance.objectNode();
        exception.put("class", t.getClass().getName());
        exception.put("message", t.getMessage());
        exception.put("stackTrace", JsonRpc20Error.stackTrace(t));
        obj.put("data", (JsonNode)exception);
        return obj;
    }

    public void write(Writer writer) throws IOException {
        JacksonHelper.MAPPER.writeValue(writer, (Object)this.jsonNode);
    }

    public static String stackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public ObjectNode getJsonNode() {
        return this.jsonNode;
    }
}

