/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jsonrpc.protocol;

import java.io.OutputStream;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

public abstract class JsonRpcRequest {
    protected String method;
    protected JsonNode id;
    protected Object[] params;
    protected ObjectNode jsonNode;

    public JsonRpcRequest(ObjectNode jsonNode) {
        this.jsonNode = jsonNode;
    }

    public JsonRpcRequest(JsonNode id, String method, Object[] params) {
        this.id = id;
        this.method = method;
        this.params = params;
        ObjectNode req = JsonNodeFactory.instance.objectNode();
        req.put("method", method);
        req.put("id", id);
        if (params != null) {
            ArrayNode args = JsonNodeFactory.instance.arrayNode();
            for (Object p : params) {
                args.add((JsonNode)JsonNodeFactory.instance.POJONode(p));
            }
            req.put("params", (JsonNode)args);
        }
        this.jsonNode = req;
    }

    public abstract void write(OutputStream var1) throws Exception;

    public boolean isNotification() {
        return this.id == null || this.id instanceof NullNode;
    }

    public String getMethod() {
        return this.method;
    }

    public JsonNode getId() {
        return this.id;
    }

    public Object[] getParams() {
        return this.params;
    }

    public ObjectNode getJsonNode() {
        return this.jsonNode;
    }
}

