/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jsonrpc.protocol;

import java.util.ArrayList;
import java.util.List;
import org.apache.tuscany.sca.binding.jsonrpc.protocol.JsonRpc20BatchResponse;
import org.apache.tuscany.sca.binding.jsonrpc.protocol.JsonRpc20Error;
import org.apache.tuscany.sca.binding.jsonrpc.protocol.JsonRpc20Request;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

public class JsonRpc20BatchRequest {
    private List<JsonRpc20Request> requests = new ArrayList<JsonRpc20Request>();
    private JsonRpc20BatchResponse batchResponse = new JsonRpc20BatchResponse();

    public JsonRpc20BatchRequest(ArrayNode array) {
        for (int i = 0; i < array.size(); ++i) {
            JsonNode req = array.get(i);
            if (req instanceof ObjectNode) {
                try {
                    this.requests.add(new JsonRpc20Request((ObjectNode)req));
                    this.batchResponse.getResponses().add(null);
                }
                catch (Exception e) {
                    JsonRpc20Error error = new JsonRpc20Error(null, 32700, "Parse error: Invalid JSON was received by the server. An error occurred on the server while parsing the JSON text.", req);
                    this.batchResponse.getResponses().add(error);
                }
                continue;
            }
            JsonRpc20Error error = new JsonRpc20Error(null, -32600, "Invalid Request: The JSON sent is not a valid Request object.", req);
            this.batchResponse.getResponses().add(error);
        }
    }

    public List<JsonRpc20Request> getRequests() {
        return this.requests;
    }

    public JsonRpc20BatchResponse getBatchResponse() {
        return this.batchResponse;
    }
}

