/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jsonrpc.protocol;

import java.io.OutputStream;
import org.apache.tuscany.sca.binding.jsonrpc.protocol.JsonRpcRequest;
import org.apache.tuscany.sca.databinding.json.jackson.JacksonHelper;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.ObjectNode;

public class JsonRpc10Request
extends JsonRpcRequest {
    public JsonRpc10Request(String id, String method, Object[] params) {
        super((JsonNode)JsonNodeFactory.instance.textNode(id), method, params);
    }

    public JsonRpc10Request(ObjectNode req) {
        super(req);
        this.method = req.get("method").getTextValue();
        this.id = req.get("id");
        JsonNode args = req.get("params");
        if (args instanceof ArrayNode) {
            ArrayNode array = (ArrayNode)args;
            this.params = new Object[array.size()];
            for (int i = 0; i < this.params.length; ++i) {
                this.params[i] = array.get(i);
            }
        } else if (args == null) {
            this.params = new Object[0];
        } else {
            throw new IllegalArgumentException("Invalid request: params is not a JSON array - " + args);
        }
    }

    @Override
    public void write(OutputStream os) throws Exception {
        JacksonHelper.MAPPER.writeValue(os, (Object)this.getJsonNode());
    }
}

