/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.wireformat;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.binding.jms.wireformat.WireFormatJMSDefault;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;

public class WireFormatJMSDefaultProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<WireFormatJMSDefault> {
    public QName getArtifactType() {
        return WireFormatJMSDefault.WIRE_FORMAT_JMS_DEFAULT_QNAME;
    }

    public WireFormatJMSDefaultProcessor(FactoryExtensionPoint modelFactories) {
    }

    public WireFormatJMSDefault read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        WireFormatJMSDefault wireFormat = new WireFormatJMSDefault();
        String sendFormat = reader.getAttributeValue(null, "sendFormat");
        if (sendFormat != null && sendFormat.length() > 0) {
            if ("text".equalsIgnoreCase(sendFormat)) {
                wireFormat.setUseBytesMessage(false);
            } else if ("bytes".equalsIgnoreCase(sendFormat)) {
                wireFormat.setUseBytesMessage(true);
            } else {
                throw new ContributionReadException(WireFormatJMSDefault.WIRE_FORMAT_JMS_DEFAULT_QNAME.toString() + " " + sendFormat + " is not a valid attribute value for " + "sendFormat");
            }
        }
        return wireFormat;
    }

    public void write(WireFormatJMSDefault wireFormat, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        String prefix = "tuscany";
        writer.writeStartElement(prefix, this.getArtifactType().getLocalPart(), this.getArtifactType().getNamespaceURI());
        writer.writeNamespace("tuscany", "http://tuscany.apache.org/xmlns/sca/1.1");
        if (wireFormat.isUseBytesMessage()) {
            writer.writeAttribute("sendFormat", "bytes");
        } else {
            writer.writeAttribute("sendFormat", "text");
        }
        writer.writeEndElement();
    }

    public Class<WireFormatJMSDefault> getModelType() {
        return WireFormatJMSDefault.class;
    }

    public void resolve(WireFormatJMSDefault arg0, ModelResolver arg1, ProcessorContext context) throws ContributionResolveException {
    }
}

