/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.policy.header;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.binding.jms.policy.header.JMSHeaderPolicy;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;

public class JMSHeaderPolicyProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<JMSHeaderPolicy> {
    public QName getArtifactType() {
        return JMSHeaderPolicy.JMS_HEADER_POLICY_QNAME;
    }

    public JMSHeaderPolicyProcessor(ExtensionPointRegistry modelFactories) {
    }

    protected void warning(Monitor monitor, String message, Object model, String ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(((Object)((Object)this)).getClass().getName(), "org.apache.tuscany.sca.assembly.xml.assembly-xml-validation-messages", Problem.Severity.WARNING, model, message, (Object[])messageParameters);
            monitor.problem(problem);
        }
    }

    protected void error(Monitor monitor, String message, Object model, Object ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(((Object)((Object)this)).getClass().getName(), "org.apache.tuscany.sca.assembly.xml.assembly-xml-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            monitor.problem(problem);
        }
    }

    public JMSHeaderPolicy read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        JMSHeaderPolicy policy = new JMSHeaderPolicy();
        int event = reader.getEventType();
        QName name = null;
        Monitor monitor = context.getMonitor();
        while (reader.hasNext()) {
            event = reader.getEventType();
            switch (event) {
                case 1: {
                    name = reader.getName();
                    if (name.equals(this.getArtifactType())) {
                        String priority;
                        String timeToLive;
                        policy.setJmsType(this.getString(reader, "JMSType"));
                        policy.setJmsCorrelationId(this.getString(reader, "JMSCorrelationID"));
                        String deliveryMode = this.getString(reader, "JMSDeliveryMode");
                        if (deliveryMode != null) {
                            if (deliveryMode.equals("PERSISTENT")) {
                                policy.setDeliveryModePersistent(true);
                            } else if (deliveryMode.equals("NON_PERSISTENT")) {
                                policy.setDeliveryModePersistent(false);
                            } else {
                                this.error(monitor, "InvalidDeliveryMode", policy, deliveryMode);
                            }
                        }
                        if ((timeToLive = this.getString(reader, "JMSTimeToLive")) != null) {
                            try {
                                policy.setTimeToLive(Long.valueOf(timeToLive));
                            }
                            catch (NumberFormatException ex) {
                                this.error(monitor, "InvalidTimeToLive", policy, timeToLive);
                            }
                        }
                        if ((priority = this.getString(reader, "JMSPriority")) == null) break;
                        try {
                            policy.setJmsPriority(Integer.valueOf(priority));
                        }
                        catch (NumberFormatException ex) {
                            this.error(monitor, "InvalidPriority", policy, priority);
                        }
                        break;
                    }
                    if (!name.getLocalPart().equals("property")) break;
                    String propertyName = this.getString(reader, "name");
                    String propertyValue = reader.getElementText();
                    policy.getProperties().put(propertyName, propertyValue);
                }
            }
            if (event == 2 && this.getArtifactType().equals(reader.getName())) break;
            if (!reader.hasNext()) continue;
            reader.next();
        }
        return policy;
    }

    public void write(JMSHeaderPolicy policy, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        String prefix = "tuscany";
        writer.writeStartElement(prefix, this.getArtifactType().getLocalPart(), this.getArtifactType().getNamespaceURI());
        writer.writeNamespace("tuscany", "http://tuscany.apache.org/xmlns/sca/1.1");
        if (policy.getJmsType() != null) {
            writer.writeAttribute("JMSType", policy.getJmsType());
        }
        if (policy.getJmsCorrelationId() != null) {
            writer.writeAttribute("JMSCorrelationID", policy.getJmsCorrelationId());
        }
        if (policy.getDeliveryModePersistent().booleanValue()) {
            writer.writeAttribute("JMSDeliveryMode", "PERSISTENT");
        } else {
            writer.writeAttribute("JMSDeliveryMode", "NON_PERSISTENT");
        }
        if (policy.getTimeToLive() != null) {
            writer.writeAttribute("JMSTimeToLive", policy.getTimeToLive().toString());
        }
        if (policy.getJmsPriority() != null) {
            writer.writeAttribute("JMSPriority", policy.getJmsPriority().toString());
        }
        for (String propertyName : policy.getProperties().keySet()) {
            writer.writeStartElement(prefix, "property", this.getArtifactType().getNamespaceURI());
            writer.writeAttribute("name", propertyName);
            writer.writeCharacters(policy.getProperties().get(propertyName));
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public Class<JMSHeaderPolicy> getModelType() {
        return JMSHeaderPolicy.class;
    }

    public void resolve(JMSHeaderPolicy arg0, ModelResolver arg1, ProcessorContext context) throws ContributionResolveException {
    }
}

