/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.wireformat.jmsobject.runtime;

import java.util.HashMap;
import java.util.List;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.binding.jms.JMSBinding;
import org.apache.tuscany.sca.binding.jms.provider.JMSResourceFactory;
import org.apache.tuscany.sca.binding.jms.wireformat.WireFormatJMSObject;
import org.apache.tuscany.sca.binding.jms.wireformat.jmsobject.runtime.WireFormatJMSObjectServiceInterceptor;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.provider.WireFormatProvider;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;

public class WireFormatJMSObjectServiceProvider
implements WireFormatProvider {
    private ExtensionPointRegistry registry;
    private RuntimeEndpoint endpoint;
    private JMSBinding binding;
    private InterfaceContract interfaceContract;
    private HashMap<String, Class<?>> singleArgMap;
    private boolean wrapSingle = true;
    private JMSResourceFactory jmsResourceFactory;

    public WireFormatJMSObjectServiceProvider(ExtensionPointRegistry registry, RuntimeEndpoint endpoint, JMSResourceFactory jmsResourceFactory) {
        this.registry = registry;
        this.endpoint = endpoint;
        this.jmsResourceFactory = jmsResourceFactory;
        this.binding = (JMSBinding)endpoint.getBinding();
        this.singleArgMap = new HashMap();
        ComponentService service = endpoint.getService();
        if (this.binding.getRequestWireFormat() instanceof WireFormatJMSObject) {
            this.binding.setRequestMessageProcessorName("org.apache.tuscany.sca.binding.jms.provider.ObjectMessageProcessor");
            List opList = service.getService().getInterfaceContract().getInterface().getOperations();
            for (Operation op : opList) {
                if (((List)op.getInputType().getLogical()).size() != 1) continue;
                this.singleArgMap.put(op.getName(), ((DataType)((List)op.getInputType().getLogical()).get(0)).getPhysical());
            }
            this.wrapSingle = ((WireFormatJMSObject)this.binding.getRequestWireFormat()).isWrappedSingleInput();
        }
        if (this.binding.getResponseWireFormat() instanceof WireFormatJMSObject) {
            this.binding.setResponseMessageProcessorName("org.apache.tuscany.sca.binding.jms.provider.ObjectMessageProcessor");
        }
        this.interfaceContract = service.getService().getInterfaceContract();
    }

    public InterfaceContract configureWireFormatInterfaceContract(InterfaceContract interfaceContract) {
        if (this.interfaceContract != null) {
            if (this.binding.getRequestWireFormat() instanceof WireFormatJMSObject) {
                interfaceContract.getInterface().resetInterfaceInputTypes(this.interfaceContract.getInterface());
            }
            if (this.binding.getResponseWireFormat() instanceof WireFormatJMSObject) {
                interfaceContract.getInterface().resetInterfaceOutputTypes(this.interfaceContract.getInterface());
            }
        }
        return interfaceContract;
    }

    public Interceptor createInterceptor() {
        return new WireFormatJMSObjectServiceInterceptor(this.registry, this.jmsResourceFactory, this.endpoint, this.singleArgMap, this.wrapSingle);
    }

    public String getPhase() {
        return "service.binding.wireformat";
    }

    public InterfaceContract getWireFormatInterfaceContract() {
        return this.interfaceContract;
    }
}

