/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.wireformat.jmsobject.runtime;

import java.util.HashMap;
import java.util.List;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.binding.jms.JMSBinding;
import org.apache.tuscany.sca.binding.jms.wireformat.WireFormatJMSObject;
import org.apache.tuscany.sca.binding.jms.wireformat.jmsobject.runtime.WireFormatJMSObjectReferenceInterceptor;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.provider.WireFormatProvider;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;

public class WireFormatJMSObjectReferenceProvider
implements WireFormatProvider {
    private ExtensionPointRegistry registry;
    private RuntimeEndpointReference endpointReference;
    private JMSBinding binding;
    private InterfaceContract interfaceContract;
    private HashMap<String, String> singleArgMap;

    public WireFormatJMSObjectReferenceProvider(ExtensionPointRegistry registry, RuntimeEndpointReference endpointReference) {
        this.registry = registry;
        this.endpointReference = endpointReference;
        this.binding = (JMSBinding)endpointReference.getBinding();
        this.singleArgMap = new HashMap();
        ComponentReference reference = endpointReference.getReference();
        if (this.binding.getRequestWireFormat() instanceof WireFormatJMSObject) {
            this.binding.setRequestMessageProcessorName("org.apache.tuscany.sca.binding.jms.provider.ObjectMessageProcessor");
            if (!((WireFormatJMSObject)this.binding.getRequestWireFormat()).isWrappedSingleInput()) {
                List opList = reference.getReference().getInterfaceContract().getInterface().getOperations();
                for (Operation op : opList) {
                    if (((List)op.getInputType().getLogical()).size() != 1) continue;
                    this.singleArgMap.put(op.getName(), "");
                }
            }
        }
        if (this.binding.getResponseWireFormat() instanceof WireFormatJMSObject) {
            this.binding.setResponseMessageProcessorName("org.apache.tuscany.sca.binding.jms.provider.ObjectMessageProcessor");
        }
        this.interfaceContract = reference.getReference().getInterfaceContract();
    }

    public InterfaceContract configureWireFormatInterfaceContract(InterfaceContract interfaceContract) {
        if (this.interfaceContract != null) {
            if (this.binding.getRequestWireFormat() instanceof WireFormatJMSObject) {
                interfaceContract.getInterface().resetInterfaceInputTypes(this.interfaceContract.getInterface());
            }
            if (this.binding.getResponseWireFormat() instanceof WireFormatJMSObject) {
                interfaceContract.getInterface().resetInterfaceOutputTypes(this.interfaceContract.getInterface());
            }
        }
        return interfaceContract;
    }

    public Interceptor createInterceptor() {
        return new WireFormatJMSObjectReferenceInterceptor(this.registry, null, this.endpointReference, this.singleArgMap);
    }

    public String getPhase() {
        return "reference.binding.wireformat";
    }

    public InterfaceContract getWireFormatInterfaceContract() {
        return this.interfaceContract;
    }
}

