/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.wireformat.jmsdefault.runtime;

import java.util.HashMap;
import java.util.List;
import javax.jms.BytesMessage;
import javax.jms.Session;
import org.apache.tuscany.sca.binding.jms.JMSBinding;
import org.apache.tuscany.sca.binding.jms.context.JMSBindingContext;
import org.apache.tuscany.sca.binding.jms.provider.DefaultMessageProcessor;
import org.apache.tuscany.sca.binding.jms.provider.JMSResourceFactory;
import org.apache.tuscany.sca.binding.jms.wireformat.WireFormatJMSDefault;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.invocation.InterceptorAsyncImpl;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;

public class WireFormatJMSDefaultServiceInterceptor
extends InterceptorAsyncImpl {
    private RuntimeEndpoint endpoint;
    private JMSResourceFactory jmsResourceFactory;
    private JMSBinding jmsBinding;
    private DefaultMessageProcessor requestMessageProcessor;
    private DefaultMessageProcessor responseMessageProcessor;
    private HashMap<String, Object> inputWrapperMap;
    private HashMap<String, Boolean> outputWrapperMap;

    public WireFormatJMSDefaultServiceInterceptor(ExtensionPointRegistry registry, JMSResourceFactory jmsResourceFactory, RuntimeEndpoint endpoint, HashMap<String, Object> inputWrapperMap, HashMap<String, Boolean> outputWrapperMap) {
        this.jmsBinding = (JMSBinding)endpoint.getBinding();
        this.endpoint = endpoint;
        this.jmsResourceFactory = jmsResourceFactory;
        this.requestMessageProcessor = new DefaultMessageProcessor(this.jmsBinding, registry);
        this.responseMessageProcessor = new DefaultMessageProcessor(this.jmsBinding, registry);
        this.inputWrapperMap = inputWrapperMap;
        this.outputWrapperMap = outputWrapperMap;
    }

    public Message invoke(Message msg) {
        Operation operation;
        if (this.jmsBinding.getRequestWireFormat() instanceof WireFormatJMSDefault) {
            msg = this.invokeRequest(msg);
        }
        if ((operation = (msg = this.getNext().invoke(msg)).getOperation()) != null && operation.isNonBlocking()) {
            return msg;
        }
        if (this.jmsBinding.getResponseWireFormat() instanceof WireFormatJMSDefault) {
            msg = this.invokeResponse(msg);
        }
        return msg;
    }

    public Message invokeRequest(Message msg) {
        JMSBindingContext context = (JMSBindingContext)msg.getBindingContext();
        javax.jms.Message jmsMsg = context.getJmsMsg();
        Operation op = msg.getOperation();
        List inputDataTypes = (List)op.getInputType().getLogical();
        Class inputType = null;
        if (inputDataTypes.size() == 1) {
            inputType = ((DataType)inputDataTypes.get(0)).getPhysical();
        }
        if (inputType != null && javax.jms.Message.class.isAssignableFrom(inputType)) {
            msg.setBody((Object)new Object[]{jmsMsg});
            if (jmsMsg instanceof BytesMessage) {
                context.setUseBytesForWFJMSDefaultResponse(true);
            } else {
                context.setUseBytesForWFJMSDefaultResponse(false);
            }
        } else {
            Object requestPayload;
            Object wrapper = this.inputWrapperMap.get(msg.getOperation().getName());
            if (jmsMsg instanceof BytesMessage) {
                requestPayload = this.responseMessageProcessor.extractPayloadFromJMSBytesMessage(jmsMsg, wrapper);
                context.setUseBytesForWFJMSDefaultResponse(true);
            } else {
                requestPayload = this.responseMessageProcessor.extractPayloadFromJMSTextMessage(jmsMsg, wrapper);
                context.setUseBytesForWFJMSDefaultResponse(false);
            }
            msg.setBody((Object)new Object[]{requestPayload});
        }
        return msg;
    }

    public Message invokeResponse(Message msg) {
        javax.jms.Message responseJMSMsg;
        JMSBindingContext context = (JMSBindingContext)msg.getBindingContext();
        if (context == null) {
            context = this.createBindingContext();
            msg.setBindingContext((Object)context);
        }
        Session session = context.getJmsResponseSession();
        boolean respondBytesMessage = context.isUseBytesForWFJMSDefaultResponse();
        if (msg.isFault()) {
            responseJMSMsg = respondBytesMessage ? this.requestMessageProcessor.createFaultJMSBytesMessage(session, (Throwable)msg.getBody()) : this.responseMessageProcessor.createFaultJMSTextMessage(session, (Throwable)msg.getBody());
        } else {
            boolean unwrap = false;
            if (this.outputWrapperMap.get(msg.getOperation().getName()) != null) {
                unwrap = this.outputWrapperMap.get(msg.getOperation().getName());
            }
            responseJMSMsg = respondBytesMessage ? this.requestMessageProcessor.insertPayloadIntoJMSBytesMessage(session, msg.getBody(), unwrap) : this.requestMessageProcessor.insertPayloadIntoJMSTextMessage(session, msg.getBody(), unwrap);
        }
        msg.setBody((Object)responseJMSMsg);
        return msg;
    }

    private JMSBindingContext createBindingContext() {
        JMSBindingContext context = new JMSBindingContext();
        context.setJmsResourceFactory(this.jmsResourceFactory);
        return context;
    }

    public Message processRequest(Message msg) {
        return this.invokeRequest(msg);
    }

    public Message processResponse(Message msg) {
        return this.invokeResponse(msg);
    }
}

