/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.wireformat.jmsdefault.runtime;

import java.util.HashMap;
import java.util.List;
import javax.jms.Message;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.Contract;
import org.apache.tuscany.sca.binding.jms.JMSBinding;
import org.apache.tuscany.sca.binding.jms.provider.xml.XMLHelper;
import org.apache.tuscany.sca.binding.jms.provider.xml.XMLHelperFactory;
import org.apache.tuscany.sca.binding.jms.wireformat.WireFormatJMSDefault;
import org.apache.tuscany.sca.binding.jms.wireformat.jmsdefault.runtime.WireFormatJMSDefaultReferenceInterceptor;
import org.apache.tuscany.sca.binding.ws.WebServiceBinding;
import org.apache.tuscany.sca.binding.ws.WebServiceBindingFactory;
import org.apache.tuscany.sca.binding.ws.wsdlgen.BindingWSDLGenerator;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.util.ElementInfo;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.provider.WireFormatProvider;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;

public class WireFormatJMSDefaultReferenceProvider
implements WireFormatProvider {
    private ExtensionPointRegistry registry;
    private RuntimeEndpointReference endpointReference;
    private ComponentReference reference;
    private JMSBinding binding;
    private InterfaceContract interfaceContract;
    private XMLHelper xmlHelper;
    private HashMap<String, Boolean> inputWrapperMap;
    private HashMap<String, Object> outputWrapperMap;

    public WireFormatJMSDefaultReferenceProvider(ExtensionPointRegistry registry, RuntimeEndpointReference endpointReference) {
        this.registry = registry;
        this.endpointReference = endpointReference;
        this.binding = (JMSBinding)endpointReference.getBinding();
        this.xmlHelper = XMLHelperFactory.createXMLHelper(registry);
        this.inputWrapperMap = new HashMap();
        this.outputWrapperMap = new HashMap();
        if (this.binding.getRequestWireFormat() instanceof WireFormatJMSDefault) {
            this.binding.setRequestMessageProcessorName("org.apache.tuscany.sca.binding.jms.provider.DefaultMessageProcessor");
        }
        if (this.binding.getResponseWireFormat() instanceof WireFormatJMSDefault) {
            this.binding.setResponseMessageProcessorName("org.apache.tuscany.sca.binding.jms.provider.DefaultMessageProcessor");
        }
        this.reference = endpointReference.getReference();
        if (this.reference.getReference() == null) {
            this.interfaceContract = this.reference.getInterfaceContract();
            return;
        }
        List opList = this.reference.getReference().getInterfaceContract().getInterface().getOperations();
        if (this.reference.getInterfaceContract() != null && !this.isAsIs()) {
            WebServiceBindingFactory wsFactory = (WebServiceBindingFactory)registry.getExtensionPoint(WebServiceBindingFactory.class);
            WebServiceBinding wsBinding = wsFactory.createWebServiceBinding();
            BindingWSDLGenerator.generateWSDL((Component)endpointReference.getComponent(), (Contract)this.reference, (WebServiceBinding)wsBinding, (ExtensionPointRegistry)registry, null);
            this.interfaceContract = wsBinding.getBindingInterfaceContract();
            this.interfaceContract.getInterface().resetDataBinding(XMLHelperFactory.createXMLHelper(registry).getDataBindingName());
            List wsdlOpList = this.interfaceContract.getInterface().getOperations();
            for (Operation op : opList) {
                String name = op.getName();
                Operation matchingWsdlOp = null;
                for (Operation wsdlOp : wsdlOpList) {
                    if (!name.equals(wsdlOp.getName())) continue;
                    matchingWsdlOp = wsdlOp;
                    break;
                }
                if (matchingWsdlOp.isInputWrapperStyle()) {
                    if (((List)op.getInputType().getLogical()).size() == 1) {
                        this.inputWrapperMap.put(name, true);
                    } else {
                        this.inputWrapperMap.put(name, false);
                    }
                } else {
                    this.inputWrapperMap.put(name, false);
                }
                if (!matchingWsdlOp.isOutputWrapperStyle()) continue;
                ElementInfo ei = op.getOutputWrapper().getWrapperElement();
                this.outputWrapperMap.put(name, this.xmlHelper.createWrapper(ei.getQName()));
            }
        } else {
            this.interfaceContract = this.reference.getReference().getInterfaceContract();
        }
    }

    protected boolean isAsIs() {
        InterfaceContract ic = this.reference.getInterfaceContract();
        if (ic.getInterface().getOperations().size() != 1) {
            return false;
        }
        List inputDataTypes = (List)((Operation)ic.getInterface().getOperations().get(0)).getInputType().getLogical();
        if (inputDataTypes.size() != 1) {
            return false;
        }
        Class inputType = ((DataType)inputDataTypes.get(0)).getPhysical();
        return Message.class.isAssignableFrom(inputType);
    }

    public InterfaceContract configureWireFormatInterfaceContract(InterfaceContract interfaceContract) {
        if (this.interfaceContract != null && !this.isAsIs()) {
            if (this.binding.getRequestWireFormat() instanceof WireFormatJMSDefault) {
                interfaceContract.getInterface().resetInterfaceInputTypes(this.interfaceContract.getInterface());
            }
            if (this.binding.getResponseWireFormat() instanceof WireFormatJMSDefault) {
                interfaceContract.getInterface().resetInterfaceOutputTypes(this.interfaceContract.getInterface());
            }
        }
        return interfaceContract;
    }

    public Interceptor createInterceptor() {
        return new WireFormatJMSDefaultReferenceInterceptor(this.registry, null, this.endpointReference, this.inputWrapperMap, this.outputWrapperMap);
    }

    public String getPhase() {
        return "reference.binding.wireformat";
    }

    public InterfaceContract getWireFormatInterfaceContract() {
        return this.interfaceContract;
    }
}

