/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.wireformat.jmsdefault.runtime;

import java.util.HashMap;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.tuscany.sca.binding.jms.JMSBinding;
import org.apache.tuscany.sca.binding.jms.JMSBindingException;
import org.apache.tuscany.sca.binding.jms.context.JMSBindingContext;
import org.apache.tuscany.sca.binding.jms.provider.DefaultMessageProcessor;
import org.apache.tuscany.sca.binding.jms.provider.JMSResourceFactory;
import org.apache.tuscany.sca.binding.jms.provider.xml.XMLHelper;
import org.apache.tuscany.sca.binding.jms.provider.xml.XMLHelperFactory;
import org.apache.tuscany.sca.binding.jms.wireformat.WireFormatJMSDefault;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.invocation.InterceptorAsyncImpl;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.util.FaultException;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;

public class WireFormatJMSDefaultReferenceInterceptor
extends InterceptorAsyncImpl {
    private Invoker next;
    private RuntimeEndpointReference endpointReference;
    private JMSResourceFactory jmsResourceFactory;
    private JMSBinding jmsBinding;
    private DefaultMessageProcessor requestMessageProcessor;
    private DefaultMessageProcessor responseMessageProcessor;
    private HashMap<String, Boolean> inputWrapperMap;
    private HashMap<String, Object> outputWrapperMap;
    private XMLHelper xmlhelper;

    public WireFormatJMSDefaultReferenceInterceptor(ExtensionPointRegistry registry, JMSResourceFactory jmsResourceFactory, RuntimeEndpointReference endpointReference, HashMap<String, Boolean> inputWrapperMap, HashMap<String, Object> outputWrapperMap) {
        this.jmsBinding = (JMSBinding)endpointReference.getBinding();
        this.endpointReference = endpointReference;
        this.jmsResourceFactory = jmsResourceFactory;
        this.requestMessageProcessor = new DefaultMessageProcessor(this.jmsBinding, registry);
        this.responseMessageProcessor = new DefaultMessageProcessor(this.jmsBinding, registry);
        this.inputWrapperMap = inputWrapperMap;
        this.outputWrapperMap = outputWrapperMap;
        this.xmlhelper = XMLHelperFactory.createXMLHelper(registry);
    }

    public Message invoke(Message msg) {
        if (this.jmsBinding.getRequestWireFormat() instanceof WireFormatJMSDefault) {
            msg = this.invokeRequest(msg);
        }
        msg = this.getNext().invoke(msg);
        if (this.jmsBinding.getResponseWireFormat() instanceof WireFormatJMSDefault) {
            msg = this.invokeResponse(msg);
        }
        return msg;
    }

    public Message invokeRequest(Message msg) {
        try {
            JMSBindingContext context = (JMSBindingContext)msg.getBindingContext();
            Session session = context.getJmsSession();
            javax.jms.Message requestMsg = ((WireFormatJMSDefault)this.jmsBinding.getRequestWireFormat()).isUseBytesMessage() ? this.requestMessageProcessor.insertPayloadIntoJMSBytesMessage(session, msg.getBody(), this.inputWrapperMap.get(msg.getOperation().getName())) : this.requestMessageProcessor.insertPayloadIntoJMSTextMessage(session, msg.getBody(), this.inputWrapperMap.get(msg.getOperation().getName()));
            msg.setBody((Object)requestMsg);
            requestMsg.setJMSReplyTo(context.getReplyToDestination());
            return msg;
        }
        catch (JMSException e) {
            throw new JMSBindingException((Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Message invokeResponse(Message msg) {
        if (msg.getBody() == null) return msg;
        javax.jms.Message jmsMsg = (javax.jms.Message)msg.getBody();
        Operation op = msg.getOperation();
        DataType outputDataType = op.getOutputType();
        Class outputType = null;
        if (outputDataType != null) {
            outputType = outputDataType.getPhysical();
        }
        if (outputType != null && javax.jms.Message.class.isAssignableFrom(outputType)) {
            msg.setBody((Object)jmsMsg);
            return msg;
        }
        Object wrapper = null;
        try {
            if (!jmsMsg.getBooleanProperty("org_apache_tuscany_sca_fault")) {
                wrapper = this.outputWrapperMap.get(msg.getOperation().getName());
            }
        }
        catch (JMSException e) {
            throw new JMSBindingException((Throwable)e);
        }
        Object response = jmsMsg instanceof BytesMessage ? this.responseMessageProcessor.extractPayloadFromJMSBytesMessage(jmsMsg, wrapper) : this.responseMessageProcessor.extractPayloadFromJMSTextMessage(jmsMsg, wrapper);
        if (response != null) {
            msg.setBody(response);
            try {
                if (!jmsMsg.getBooleanProperty("org_apache_tuscany_sca_fault")) return msg;
                FaultException e = new FaultException("remote exception", response);
                this.xmlhelper.setFaultName(e, response);
                msg.setFaultBody((Object)e);
                return msg;
            }
            catch (JMSException e) {
                throw new JMSBindingException((Throwable)e);
            }
        } else {
            msg.setBody(null);
        }
        return msg;
    }

    public Invoker getNext() {
        return this.next;
    }

    public void setNext(Invoker next) {
        this.next = next;
    }

    public Message processRequest(Message msg) {
        return this.invokeRequest(msg);
    }

    public Message processResponse(Message msg) {
        return this.invokeResponse(msg);
    }
}

