/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.wireformat.jmsbytesxml.runtime;

import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.Contract;
import org.apache.tuscany.sca.binding.jms.JMSBinding;
import org.apache.tuscany.sca.binding.jms.provider.JMSResourceFactory;
import org.apache.tuscany.sca.binding.jms.provider.xml.XMLHelperFactory;
import org.apache.tuscany.sca.binding.jms.wireformat.WireFormatJMSBytesXML;
import org.apache.tuscany.sca.binding.jms.wireformat.jmsbytesxml.runtime.WireFormatJMSBytesXMLServiceInterceptor;
import org.apache.tuscany.sca.binding.ws.WebServiceBinding;
import org.apache.tuscany.sca.binding.ws.WebServiceBindingFactory;
import org.apache.tuscany.sca.binding.ws.wsdlgen.BindingWSDLGenerator;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.provider.WireFormatProvider;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;

public class WireFormatJMSBytesXMLServiceProvider
implements WireFormatProvider {
    private ExtensionPointRegistry registry;
    private RuntimeEndpoint endpoint;
    private JMSBinding binding;
    private JMSResourceFactory jmsResourceFactory;
    private InterfaceContract interfaceContract;

    public WireFormatJMSBytesXMLServiceProvider(ExtensionPointRegistry registry, RuntimeEndpoint endpoint, JMSResourceFactory jmsResourceFactory) {
        this.registry = registry;
        this.endpoint = endpoint;
        this.binding = (JMSBinding)endpoint.getBinding();
        this.jmsResourceFactory = jmsResourceFactory;
        if (this.binding.getRequestWireFormat() instanceof WireFormatJMSBytesXML) {
            this.binding.setRequestMessageProcessorName("org.apache.tuscany.sca.binding.jms.provider.XMLBytesMessageProcessor");
        }
        if (this.binding.getResponseWireFormat() instanceof WireFormatJMSBytesXML) {
            this.binding.setResponseMessageProcessorName("org.apache.tuscany.sca.binding.jms.provider.XMLBytesMessageProcessor");
        }
        WebServiceBindingFactory wsFactory = (WebServiceBindingFactory)registry.getExtensionPoint(WebServiceBindingFactory.class);
        WebServiceBinding wsBinding = wsFactory.createWebServiceBinding();
        BindingWSDLGenerator.generateWSDL((Component)endpoint.getComponent(), (Contract)endpoint.getService(), (WebServiceBinding)wsBinding, (ExtensionPointRegistry)registry, null);
        this.interfaceContract = wsBinding.getBindingInterfaceContract();
        this.interfaceContract.getInterface().resetDataBinding(XMLHelperFactory.createXMLHelper(registry).getDataBindingName());
    }

    public InterfaceContract configureWireFormatInterfaceContract(InterfaceContract interfaceContract) {
        if (this.interfaceContract != null) {
            if (this.binding.getRequestWireFormat() instanceof WireFormatJMSBytesXML) {
                interfaceContract.getInterface().resetInterfaceInputTypes(this.interfaceContract.getInterface());
            }
            if (this.binding.getResponseWireFormat() instanceof WireFormatJMSBytesXML) {
                interfaceContract.getInterface().resetInterfaceOutputTypes(this.interfaceContract.getInterface());
            }
        }
        return interfaceContract;
    }

    public Interceptor createInterceptor() {
        return new WireFormatJMSBytesXMLServiceInterceptor(this.registry, this.jmsResourceFactory, this.endpoint);
    }

    public String getPhase() {
        return "service.binding.wireformat";
    }

    public InterfaceContract getWireFormatInterfaceContract() {
        return this.interfaceContract;
    }
}

