/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.provider.xml;

import java.io.IOException;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.binding.jms.provider.xml.XMLHelper;
import org.apache.tuscany.sca.common.xml.dom.DOMHelper;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.interfacedef.util.FaultException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DOMXMLHelper
implements XMLHelper<Node> {
    private DOMHelper domHelper;

    public DOMXMLHelper(ExtensionPointRegistry epr) {
        this.domHelper = DOMHelper.getInstance((ExtensionPointRegistry)epr);
    }

    @Override
    public Document load(String xml) throws IOException {
        try {
            return this.domHelper.load(xml);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    @Override
    public String saveAsString(Node t) {
        return this.domHelper.saveAsString(t);
    }

    @Override
    public String getOperationName(Node t) {
        Node firstChild = t.getFirstChild();
        if (firstChild != null) {
            return firstChild.getLocalName();
        }
        return null;
    }

    @Override
    public Object wrap(Node wrapper, Node os) {
        Node node = os;
        if (node == null) {
            node = this.domHelper.newDocument();
        }
        Element newWrapper = DOMHelper.createElement((Document)((Document)node), (QName)new QName(wrapper.getNamespaceURI(), wrapper.getLocalName()));
        if (os != null) {
            Node child = node.getFirstChild();
            newWrapper.appendChild(child);
        }
        return newWrapper;
    }

    @Override
    public Node createWrapper(QName qname) {
        Document document = this.domHelper.newDocument();
        Element wrapper = DOMHelper.createElement((Document)document, (QName)qname);
        return wrapper;
    }

    @Override
    public String getDataBindingName() {
        return Node.class.getName();
    }

    @Override
    public Node getFirstChild(Node o) {
        return o.getFirstChild();
    }

    @Override
    public void setFaultName(FaultException e, Object response) {
        Node n = ((Node)response).getFirstChild();
        e.setFaultName(new QName(n.getNamespaceURI(), n.getLocalName()));
    }
}

