/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.provider;

import java.io.IOException;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.tuscany.sca.binding.jms.JMSBinding;
import org.apache.tuscany.sca.binding.jms.JMSBindingException;
import org.apache.tuscany.sca.binding.jms.provider.AbstractMessageProcessor;
import org.apache.tuscany.sca.binding.jms.provider.xml.XMLHelper;
import org.apache.tuscany.sca.binding.jms.provider.xml.XMLHelperFactory;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.interfacedef.util.FaultException;

public class XMLTextMessageProcessor
extends AbstractMessageProcessor {
    private static final Logger logger = Logger.getLogger(XMLTextMessageProcessor.class.getName());
    private XMLHelper xmlHelper;

    public XMLTextMessageProcessor(JMSBinding jmsBinding, ExtensionPointRegistry registry) {
        super(jmsBinding);
        this.xmlHelper = XMLHelperFactory.createXMLHelper(registry);
    }

    @Override
    protected Object extractPayload(Message msg) {
        try {
            String xml = ((TextMessage)msg).getText();
            Object os = xml != null ? this.xmlHelper.load(xml) : null;
            return os;
        }
        catch (IOException e) {
            throw new JMSBindingException((Throwable)e);
        }
        catch (JMSException e) {
            throw new JMSBindingException((Throwable)e);
        }
    }

    @Override
    public Object extractPayloadFromJMSMessage(Message msg) {
        if (msg instanceof TextMessage) {
            return this.extractPayload(msg);
        }
        return super.extractPayloadFromJMSMessage(msg);
    }

    @Override
    protected Message createJMSMessage(Session session, Object o) {
        if (session == null) {
            logger.fine("no response session to create message: " + String.valueOf(o));
            return null;
        }
        try {
            TextMessage message = session.createTextMessage();
            if (o instanceof Object[]) {
                message.setText(this.xmlHelper.saveAsString(((Object[])o)[0]));
            } else {
                message.setText(this.xmlHelper.saveAsString(o));
            }
            return message;
        }
        catch (JMSException e) {
            throw new JMSBindingException((Throwable)e);
        }
    }

    @Override
    public Message createFaultMessage(Session session, Throwable o) {
        if (session == null) {
            logger.fine("no response session to create fault message: " + String.valueOf(o));
            return null;
        }
        if (o instanceof FaultException) {
            try {
                TextMessage message = session.createTextMessage();
                message.setText(this.xmlHelper.saveAsString(((FaultException)o).getFaultInfo()));
                message.setBooleanProperty("org_apache_tuscany_sca_fault", true);
                return message;
            }
            catch (JMSException e) {
                throw new JMSBindingException((Throwable)e);
            }
        }
        return super.createFaultMessage(session, o);
    }
}

