/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.provider;

import java.lang.reflect.InvocationTargetException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.naming.NamingException;
import org.apache.tuscany.sca.binding.jms.JMSBinding;
import org.apache.tuscany.sca.binding.jms.JMSBindingException;
import org.apache.tuscany.sca.binding.jms.context.JMSBindingContext;
import org.apache.tuscany.sca.binding.jms.provider.JMSResourceFactory;
import org.apache.tuscany.sca.core.invocation.InterceptorAsyncImpl;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.util.FaultException;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;
import org.oasisopen.sca.ServiceRuntimeException;

public class RRBJMSBindingInvoker
extends InterceptorAsyncImpl {
    protected Operation operation;
    protected String operationName;
    protected JMSBinding jmsBinding;
    protected JMSResourceFactory jmsResourceFactory;
    protected Destination bindingRequestDest;
    protected Destination bindingReplyDest;
    protected RuntimeEndpointReference endpointReference;

    public RRBJMSBindingInvoker(Operation operation, JMSResourceFactory jmsResourceFactory, RuntimeEndpointReference epr) {
        this.operation = operation;
        this.operationName = operation.getName();
        this.endpointReference = epr;
        this.jmsBinding = (JMSBinding)epr.getBinding();
        this.jmsResourceFactory = jmsResourceFactory;
        try {
            this.bindingRequestDest = this.lookupDestination();
            this.bindingReplyDest = this.lookupResponseDestination();
        }
        catch (NamingException e) {
            throw new JMSBindingException((Throwable)e);
        }
    }

    protected Destination lookupDestination() throws NamingException, JMSBindingException {
        return this.lookupDestinationQueue(false);
    }

    protected Destination lookupResponseDestination() throws NamingException, JMSBindingException {
        return this.lookupDestinationQueue(true);
    }

    protected Destination lookupDestinationQueue(boolean isReponseQueue) throws NamingException, JMSBindingException {
        String qCreateMode;
        String queueType;
        String queueName;
        if (isReponseQueue) {
            queueName = this.jmsBinding.getResponseDestinationName();
            queueType = "JMS Response Destination ";
            qCreateMode = this.jmsBinding.getResponseDestinationCreate();
            if (queueName == null) {
                return null;
            }
        } else {
            queueName = this.jmsBinding.getDestinationName();
            queueType = "JMS Destination ";
            qCreateMode = this.jmsBinding.getDestinationCreate();
        }
        if (queueName.startsWith("jms:jndi:")) {
            queueName = queueName.substring("jms:jndi:".length());
        }
        Destination dest = this.jmsResourceFactory.lookupDestination(queueName);
        if (qCreateMode.equals("always")) {
            if (dest != null) {
                throw new JMSBindingException(queueType + queueName + " already exists but has create mode of \"" + qCreateMode + "\" while registering binding " + this.jmsBinding.getName() + " invoker");
            }
            dest = this.jmsResourceFactory.createDestination(queueName);
        } else if (qCreateMode.equals("ifNotExist")) {
            if (dest == null && !"jndi".equals(this.jmsBinding.getDestinationType())) {
                dest = this.jmsResourceFactory.createDestination(queueName);
            }
        } else if (qCreateMode.equals("never") && dest == null) {
            throw new JMSBindingException(queueType + queueName + " not found but create mode of \"" + qCreateMode + "\" while registering binding " + this.jmsBinding.getName() + " invoker");
        }
        if (dest == null) {
            throw new JMSBindingException(queueType + queueName + " not found with create mode of \"" + qCreateMode + "\" while registering binding " + this.jmsBinding.getName() + " invoker");
        }
        return dest;
    }

    public Invoker getNext() {
        return this.endpointReference.getBindingInvocationChain().getHeadInvoker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message invoke(Message tuscanyMsg) {
        try {
            JMSBindingContext context = new JMSBindingContext();
            context.setJmsResourceFactory(this.jmsResourceFactory);
            tuscanyMsg.setBindingContext((Object)context);
            Session session = context.getJmsSession();
            context.setRequestDestination(this.getRequestDestination(tuscanyMsg, session));
            context.setReplyToDestination(this.getReplyToDestination(session));
            Long ttl = this.jmsBinding.getOperationJMSTimeToLive(this.operationName);
            if (ttl != null) {
                context.setTimeToLive(ttl);
            }
            if (!this.operation.isNonBlocking()) {
                if (ttl != null) {
                    context.setRequestTimeout(ttl * 2L);
                } else {
                    long timeout = this.jmsResourceFactory.getDefaultRequestTimeout();
                    context.setRequestTimeout(timeout);
                    context.setTimeToLive(timeout);
                }
            }
            try {
                tuscanyMsg = this.endpointReference.getBindingInvocationChain().getHeadInvoker().invoke(tuscanyMsg);
            }
            catch (ServiceRuntimeException e) {
                if (e.getCause() instanceof InvocationTargetException) {
                    if (e.getCause().getCause() instanceof RuntimeException) {
                        tuscanyMsg.setFaultBody((Object)e.getCause());
                    } else {
                        tuscanyMsg.setFaultBody((Object)((InvocationTargetException)e.getCause()).getTargetException());
                    }
                } else if (e.getCause() instanceof FaultException) {
                    tuscanyMsg.setFaultBody((Object)e.getCause());
                } else {
                    tuscanyMsg.setFaultBody((Object)e);
                }
            }
            catch (IllegalStateException e) {
                tuscanyMsg.setFaultBody((Object)e);
            }
            catch (Throwable e) {
                tuscanyMsg.setFaultBody((Object)e);
            }
            finally {
                context.closeJmsSession();
                if (this.jmsResourceFactory.isConnectionClosedAfterUse()) {
                    this.jmsResourceFactory.closeConnection();
                }
            }
            return tuscanyMsg;
        }
        catch (Exception e) {
            throw new JMSBindingException((Throwable)e);
        }
    }

    protected Destination getRequestDestination(Message tuscanyMsg, Session session) throws JMSBindingException, NamingException, JMSException {
        Destination requestDestination = null;
        if (this.endpointReference.getReference().isForCallback() && tuscanyMsg.getFrom().getTargetEndpoint() != null && tuscanyMsg.getFrom().getTargetEndpoint().getBinding() != null) {
            this.jmsBinding = (JMSBinding)tuscanyMsg.getFrom().getTargetEndpoint().getBinding();
            requestDestination = this.lookupDestination();
        }
        if (requestDestination == null) {
            requestDestination = this.bindingRequestDest;
        }
        return requestDestination;
    }

    protected Destination getReplyToDestination(Session session) throws JMSException, JMSBindingException, NamingException {
        Object replyToDest = this.operation.isNonBlocking() && this.endpointReference.getComponentReferenceInterfaceContract().getCallbackInterface() == null ? null : (this.bindingReplyDest != null ? this.bindingReplyDest : session.createTemporaryQueue());
        return replyToDest;
    }

    public Message processRequest(Message tuscanyMsg) {
        try {
            JMSBindingContext context = new JMSBindingContext();
            context.setJmsResourceFactory(this.jmsResourceFactory);
            tuscanyMsg.setBindingContext((Object)context);
            Session session = context.getJmsSession();
            context.setRequestDestination(this.getRequestDestination(tuscanyMsg, session));
            context.setReplyToDestination(this.getReplyToDestination(session));
            return tuscanyMsg;
        }
        catch (Exception e) {
            throw new JMSBindingException((Throwable)e);
        }
    }

    public Message postProcessRequest(Message tuscanyMsg, Throwable e) {
        if (e instanceof ServiceRuntimeException) {
            if (e.getCause() instanceof InvocationTargetException) {
                if (e.getCause().getCause() instanceof RuntimeException) {
                    tuscanyMsg.setFaultBody((Object)e.getCause());
                } else {
                    tuscanyMsg.setFaultBody((Object)((InvocationTargetException)e.getCause()).getTargetException());
                }
            } else if (e.getCause() instanceof FaultException) {
                tuscanyMsg.setFaultBody((Object)e.getCause());
            } else {
                tuscanyMsg.setFaultBody((Object)e);
            }
        } else {
            tuscanyMsg.setFaultBody((Object)e);
        }
        return this.postProcessRequest(tuscanyMsg);
    }

    public Message postProcessRequest(Message tuscanyMsg) {
        try {
            JMSBindingContext context = (JMSBindingContext)tuscanyMsg.getBindingContext();
            context.closeJmsSession();
            if (this.jmsResourceFactory.isConnectionClosedAfterUse()) {
                this.jmsResourceFactory.closeConnection();
            }
        }
        catch (JMSException ex) {
            throw new JMSBindingException((Throwable)ex);
        }
        return tuscanyMsg;
    }

    public Message processResponse(Message tuscanyMsg) {
        return tuscanyMsg;
    }
}

