/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.provider;

import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.spi.ActivationSpec;
import org.apache.tuscany.sca.binding.jms.JMSBindingException;
import org.apache.tuscany.sca.binding.jms.provider.JMSResourceFactory;

public class JMSResourceFactoryImpl
implements JMSResourceFactory {
    protected String initialContextFactoryName;
    protected String connectionFactoryName = "ConnectionFactory";
    protected String jndiURL;
    protected Connection connection;
    protected Context context;
    protected boolean isConnectionStarted;
    private Connection responseConnection;
    private String responseConnectionFactoryName;

    public JMSResourceFactoryImpl(String connectionFactoryName, String responseConnectionFactoryName, String initialContextFactoryName, String jndiURL) {
        if (connectionFactoryName != null && connectionFactoryName.trim().length() > 0) {
            this.connectionFactoryName = connectionFactoryName.trim();
        }
        if (responseConnectionFactoryName != null && responseConnectionFactoryName.trim().length() > 0) {
            this.responseConnectionFactoryName = responseConnectionFactoryName.trim();
        }
        if (initialContextFactoryName != null && initialContextFactoryName.trim().length() > 0) {
            this.initialContextFactoryName = initialContextFactoryName.trim();
        }
        if (jndiURL != null) {
            this.jndiURL = jndiURL.trim();
        }
    }

    @Override
    public Connection getConnection() throws NamingException, JMSException {
        if (this.connection == null) {
            this.createConnection();
        }
        return this.connection;
    }

    @Override
    public Session createSession() throws JMSException, NamingException {
        return this.getConnection().createSession(false, 1);
    }

    @Override
    public void closeSession(Session session) throws JMSException {
        session.close();
    }

    @Override
    public void startConnection() throws JMSException, NamingException {
        if (!this.isConnectionStarted) {
            this.getConnection().start();
            this.isConnectionStarted = true;
        }
    }

    @Override
    public void closeConnection() throws JMSException {
        block3: {
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (JMSException e) {
                    if (e.getMessage().contains("disposed")) break block3;
                    throw e;
                }
            }
        }
    }

    protected void createConnection() throws NamingException, JMSException {
        Object o = this.jndiLookUp(this.connectionFactoryName);
        if (o == null) {
            throw new JMSBindingException("connection factory not found: " + this.connectionFactoryName);
        }
        if (!(o instanceof ConnectionFactory)) {
            throw new JMSBindingException("JNDI resource '" + this.connectionFactoryName + "' is not a JMS ConnectionFactory");
        }
        ConnectionFactory connectionFactory = (ConnectionFactory)o;
        this.connection = connectionFactory.createConnection();
    }

    protected synchronized Context getInitialContext() throws NamingException {
        if (this.context == null) {
            Properties props = new Properties();
            if (this.initialContextFactoryName != null) {
                props.setProperty("java.naming.factory.initial", this.initialContextFactoryName);
            }
            if (this.jndiURL != null) {
                props.setProperty("java.naming.provider.url", this.jndiURL);
            }
            this.initJREEnvironment(props);
            this.context = new InitialContext(props);
        }
        return this.context;
    }

    protected void initJREEnvironment(Properties props) {
        String vendor;
        if ("com.ibm.websphere.naming.WsnInitialContextFactory".equals(props.get("java.naming.factory.initial")) && ((vendor = System.getProperty("java.vendor")) == null || !vendor.contains("IBM"))) {
            props.setProperty("com.ibm.CORBA.ORBInit", "com.ibm.ws.sib.client.ORB");
        }
    }

    @Override
    public Destination lookupDestination(String destName) throws NamingException {
        if (destName == null) {
            return null;
        }
        Destination dest = (Destination)this.jndiLookUp(destName);
        if (dest == null) {
            dest = this.lookupPhysical(destName);
        }
        return dest;
    }

    protected Destination lookupPhysical(String jndiName) {
        return null;
    }

    @Override
    public Destination createDestination(String jndiName) throws NamingException {
        if (jndiName == null) {
            return null;
        }
        return this.lookupDestination("dynamicQueues/" + jndiName);
    }

    protected Object jndiLookUp(String name) {
        Object o = null;
        try {
            o = this.getInitialContext().lookup("java:comp/env/" + name);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (o == null) {
            try {
                o = this.getInitialContext().lookup(name);
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return o;
    }

    @Override
    public Session createResponseSession() throws JMSException, NamingException {
        return this.getResponseConnection().createSession(false, 1);
    }

    @Override
    public void closeResponseSession(Session session) throws JMSException {
        session.close();
    }

    @Override
    public Connection getResponseConnection() throws NamingException, JMSException {
        if (this.responseConnection == null) {
            if (this.responseConnectionFactoryName != null) {
                ConnectionFactory connectionFactory = (ConnectionFactory)this.jndiLookUp(this.responseConnectionFactoryName);
                if (connectionFactory == null) {
                    throw new JMSBindingException("connection factory not found: " + this.responseConnectionFactoryName);
                }
                this.responseConnection = connectionFactory.createConnection();
            } else {
                this.responseConnection = this.getConnection();
            }
        }
        return this.responseConnection;
    }

    @Override
    public void closeResponseConnection() throws JMSException {
        block3: {
            if (this.responseConnection != null && !this.responseConnection.equals(this.connection)) {
                try {
                    this.responseConnection.close();
                }
                catch (JMSException e) {
                    if (e.getMessage().contains("disposed")) break block3;
                    throw e;
                }
            }
        }
    }

    @Override
    public boolean isConnectionClosedAfterUse() {
        return false;
    }

    @Override
    public ActivationSpec lookupActivationSpec(String activationSpecName) {
        Object o = this.jndiLookUp(activationSpecName);
        if (o == null) {
            return null;
        }
        if (o instanceof ActivationSpec) {
            return (ActivationSpec)o;
        }
        throw new JMSBindingException("Incorrect resource type for ActivationSpec: " + o.getClass().getName());
    }

    @Override
    public long getDefaultRequestTimeout() {
        return 0L;
    }
}

