/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.provider;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.tuscany.sca.binding.jms.JMSBinding;
import org.apache.tuscany.sca.binding.jms.JMSBindingException;
import org.apache.tuscany.sca.binding.jms.provider.JMSMessageProcessor;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;

public class JMSMessageProcessorUtil {
    private static Object instantiate(ClassLoader cl, final String className, final JMSBinding binding) {
        Object instance;
        if (cl == null) {
            cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return binding.getClass().getClassLoader();
                }
            });
        }
        try {
            Class clazz;
            try {
                clazz = cl.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                try {
                    clazz = AccessController.doPrivileged(new PrivilegedExceptionAction<Class>(){

                        @Override
                        public Class run() throws ClassNotFoundException {
                            return binding.getClass().getClassLoader().loadClass(className);
                        }
                    });
                }
                catch (PrivilegedActionException ex) {
                    throw (ClassNotFoundException)ex.getException();
                }
            }
            Constructor constructor = clazz.getDeclaredConstructor(JMSBinding.class);
            instance = constructor.newInstance(binding);
        }
        catch (Throwable e) {
            throw new JMSBindingException("Exception instantiating OperationAndDataBinding class", e);
        }
        return instance;
    }

    private static Object instantiate(ClassLoader cl, String className, JMSBinding binding, ExtensionPointRegistry registry) {
        try {
            for (ServiceDeclaration sd : registry.getServiceDiscovery().getServiceDeclarations(JMSMessageProcessor.class)) {
                Constructor constructor;
                if (!className.equals(sd.getClassName())) continue;
                final Class clazz = sd.loadClass();
                try {
                    constructor = (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction<Constructor<?>>(){

                        @Override
                        public Constructor<?> run() throws NoSuchMethodException {
                            return clazz.getDeclaredConstructor(JMSBinding.class, ExtensionPointRegistry.class);
                        }
                    });
                }
                catch (PrivilegedActionException ex) {
                    throw (NoSuchMethodException)ex.getException();
                }
                return constructor.newInstance(binding, registry);
            }
            throw new JMSBindingException("Class not found: " + className);
        }
        catch (Throwable e) {
            throw new JMSBindingException("Exception instantiating OperationAndDataBinding class", e);
        }
    }

    public static JMSMessageProcessor getRequestMessageProcessor(ExtensionPointRegistry registry, JMSBinding binding) {
        return (JMSMessageProcessor)JMSMessageProcessorUtil.instantiate(null, binding.getRequestMessageProcessorName(), binding, registry);
    }

    public static JMSMessageProcessor getResponseMessageProcessor(ExtensionPointRegistry registry, JMSBinding binding) {
        return (JMSMessageProcessor)JMSMessageProcessorUtil.instantiate(null, binding.getResponseMessageProcessorName(), binding, registry);
    }
}

