/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.provider;

import org.apache.tuscany.sca.binding.jms.JMSBinding;
import org.apache.tuscany.sca.binding.jms.host.DefaultJMSHostExtensionPoint;
import org.apache.tuscany.sca.binding.jms.host.JMSHostExtensionPoint;
import org.apache.tuscany.sca.binding.jms.host.JMSServiceListenerFactory;
import org.apache.tuscany.sca.binding.jms.provider.DefaultJMSResourceFactoryExtensionPoint;
import org.apache.tuscany.sca.binding.jms.provider.JMSBindingReferenceBindingProvider;
import org.apache.tuscany.sca.binding.jms.provider.JMSBindingServiceBindingProvider;
import org.apache.tuscany.sca.binding.jms.provider.JMSResourceFactory;
import org.apache.tuscany.sca.binding.jms.provider.JMSResourceFactoryExtensionPoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.provider.BindingProviderFactory;
import org.apache.tuscany.sca.provider.ReferenceBindingProvider;
import org.apache.tuscany.sca.provider.ServiceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;

public class JMSBindingProviderFactory
implements BindingProviderFactory<JMSBinding> {
    protected ExtensionPointRegistry extensionPoints;
    protected JMSResourceFactoryExtensionPoint jmsRFEP;
    protected JMSServiceListenerFactory serviceListenerFactory;

    public JMSBindingProviderFactory(ExtensionPointRegistry extensionPoints) {
        JMSHostExtensionPoint jmsHostExtensionPoint;
        this.extensionPoints = extensionPoints;
        this.jmsRFEP = (JMSResourceFactoryExtensionPoint)extensionPoints.getExtensionPoint(JMSResourceFactoryExtensionPoint.class);
        if (this.jmsRFEP == null) {
            this.jmsRFEP = new DefaultJMSResourceFactoryExtensionPoint();
            extensionPoints.addExtensionPoint((Object)this.jmsRFEP);
        }
        if ((jmsHostExtensionPoint = (JMSHostExtensionPoint)extensionPoints.getExtensionPoint(JMSHostExtensionPoint.class)) == null) {
            jmsHostExtensionPoint = new DefaultJMSHostExtensionPoint(extensionPoints);
            extensionPoints.addExtensionPoint((Object)jmsHostExtensionPoint);
        }
        this.serviceListenerFactory = jmsHostExtensionPoint.getJMSServiceListenerFactory();
    }

    public ReferenceBindingProvider createReferenceBindingProvider(RuntimeEndpointReference endpointReference) {
        JMSResourceFactory jmsRF = this.jmsRFEP.createJMSResourceFactory((JMSBinding)endpointReference.getBinding());
        return new JMSBindingReferenceBindingProvider(endpointReference, this.extensionPoints, jmsRF);
    }

    public ServiceBindingProvider createServiceBindingProvider(RuntimeEndpoint endpoint) {
        JMSBinding binding = (JMSBinding)endpoint.getBinding();
        JMSResourceFactory jmsRF = this.jmsRFEP.createJMSResourceFactory(binding);
        return new JMSBindingServiceBindingProvider(this.extensionPoints, endpoint, this.serviceListenerFactory, this.extensionPoints, jmsRF);
    }

    public Class<JMSBinding> getModelType() {
        return JMSBinding.class;
    }
}

