/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.provider;

import java.io.IOException;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.tuscany.sca.binding.jms.JMSBinding;
import org.apache.tuscany.sca.binding.jms.JMSBindingException;
import org.apache.tuscany.sca.binding.jms.provider.AbstractMessageProcessor;
import org.apache.tuscany.sca.binding.jms.provider.xml.XMLHelper;
import org.apache.tuscany.sca.binding.jms.provider.xml.XMLHelperFactory;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.interfacedef.util.FaultException;

public class DefaultMessageProcessor
extends AbstractMessageProcessor {
    private static final Logger logger = Logger.getLogger(DefaultMessageProcessor.class.getName());
    private XMLHelper xmlHelper;

    public DefaultMessageProcessor(JMSBinding jmsBinding, ExtensionPointRegistry registry) {
        super(jmsBinding);
        this.xmlHelper = XMLHelperFactory.createXMLHelper(registry);
    }

    @Override
    protected Message createJMSMessage(Session session, Object o) {
        return null;
    }

    @Override
    protected Object extractPayload(Message msg) {
        return null;
    }

    @Override
    public Message createFaultMessage(Session session, Throwable o) {
        return this.createFaultJMSBytesMessage(session, o);
    }

    public Object extractPayloadFromJMSTextMessage(Message msg, Object wrapper) {
        if (msg instanceof TextMessage) {
            try {
                String xml = ((TextMessage)msg).getText();
                Object os = xml != null && xml.length() > 0 ? (Object)this.xmlHelper.load(xml) : null;
                if (wrapper != null) {
                    return this.xmlHelper.wrap(wrapper, os);
                }
                return os;
            }
            catch (JMSException e) {
                throw new JMSBindingException((Throwable)e);
            }
            catch (IOException e) {
                throw new JMSBindingException((Throwable)e);
            }
        }
        return super.extractPayloadFromJMSMessage(msg);
    }

    public Message insertPayloadIntoJMSTextMessage(Session session, Object o, boolean unwrap) {
        try {
            TextMessage message = session.createTextMessage();
            if (o instanceof Object[]) {
                if (unwrap) {
                    Object firstElement = this.xmlHelper.getFirstChild(((Object[])o)[0]);
                    if (firstElement == null) {
                        message.setText(null);
                    } else {
                        message.setText(this.xmlHelper.saveAsString(firstElement));
                    }
                } else {
                    message.setText(this.xmlHelper.saveAsString(((Object[])o)[0]));
                }
            } else if (o != null) {
                if (unwrap) {
                    Object firstElement = this.xmlHelper.getFirstChild(o);
                    if (firstElement == null) {
                        message.setText("");
                    } else {
                        message.setText(this.xmlHelper.saveAsString(firstElement));
                    }
                } else {
                    message.setText(this.xmlHelper.saveAsString(o));
                }
            }
            return message;
        }
        catch (JMSException e) {
            throw new JMSBindingException((Throwable)e);
        }
    }

    public Message createFaultJMSTextMessage(Session session, Throwable o) {
        if (session == null) {
            logger.fine("no response session to create fault message: " + String.valueOf(o));
            return null;
        }
        if (o instanceof FaultException) {
            try {
                TextMessage message = session.createTextMessage();
                message.setText(this.xmlHelper.saveAsString(((FaultException)o).getFaultInfo()));
                message.setBooleanProperty("org_apache_tuscany_sca_fault", true);
                return message;
            }
            catch (JMSException e) {
                throw new JMSBindingException((Throwable)e);
            }
        }
        return super.createFaultMessage(session, o);
    }

    public Object extractPayloadFromJMSBytesMessage(Message msg, Object wrapper) {
        if (msg instanceof BytesMessage) {
            try {
                long noOfBytes = ((BytesMessage)msg).getBodyLength();
                byte[] bytes = new byte[(int)noOfBytes];
                ((BytesMessage)msg).readBytes(bytes);
                ((BytesMessage)msg).reset();
                Object os = bytes != null && bytes.length > 0 ? (Object)this.xmlHelper.load(new String(bytes)) : null;
                if (wrapper != null) {
                    return this.xmlHelper.wrap(wrapper, os);
                }
                return os;
            }
            catch (JMSException e) {
                throw new JMSBindingException((Throwable)e);
            }
            catch (IOException e) {
                throw new JMSBindingException((Throwable)e);
            }
        }
        return super.extractPayloadFromJMSMessage(msg);
    }

    public Message insertPayloadIntoJMSBytesMessage(Session session, Object o, boolean unwrap) {
        try {
            BytesMessage message = session.createBytesMessage();
            if (o instanceof Object[]) {
                if (unwrap) {
                    Object firstElement = this.xmlHelper.getFirstChild(((Object[])o)[0]);
                    if (firstElement != null) {
                        message.writeBytes(this.xmlHelper.saveAsString(firstElement).getBytes());
                    }
                } else {
                    message.writeBytes(this.xmlHelper.saveAsString(((Object[])o)[0]).getBytes());
                }
            } else if (o != null) {
                if (unwrap) {
                    Object firstElement = this.xmlHelper.getFirstChild(o);
                    if (firstElement != null) {
                        message.writeBytes(this.xmlHelper.saveAsString(firstElement).getBytes());
                    }
                } else {
                    message.writeBytes(this.xmlHelper.saveAsString(o).getBytes());
                }
            }
            return message;
        }
        catch (JMSException e) {
            throw new JMSBindingException((Throwable)e);
        }
    }

    public Message createFaultJMSBytesMessage(Session session, Throwable o) {
        if (session == null) {
            logger.fine("no response session to create fault message: " + String.valueOf(o));
            return null;
        }
        if (o instanceof FaultException) {
            try {
                BytesMessage message = session.createBytesMessage();
                String s = this.xmlHelper.saveAsString(((FaultException)o).getFaultInfo());
                message.writeBytes(s.getBytes());
                message.setBooleanProperty("org_apache_tuscany_sca_fault", true);
                return message;
            }
            catch (JMSException e) {
                throw new JMSBindingException((Throwable)e);
            }
        }
        return super.createFaultMessage(session, o);
    }
}

