/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.provider;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import org.apache.tuscany.sca.binding.jms.JMSBinding;
import org.apache.tuscany.sca.binding.jms.JMSBindingException;
import org.apache.tuscany.sca.binding.jms.provider.JMSMessageProcessor;
import org.oasisopen.sca.ServiceRuntimeException;

public abstract class AbstractMessageProcessor
implements JMSMessageProcessor {
    private static final Logger logger = Logger.getLogger(AbstractMessageProcessor.class.getName());
    protected String operationPropertyName;
    protected boolean xmlFormat = true;

    public AbstractMessageProcessor(JMSBinding jmsBinding) {
        this.operationPropertyName = jmsBinding.getOperationSelectorPropertyName();
    }

    @Override
    public String getOperationName(Message message) {
        try {
            return message.getStringProperty(this.operationPropertyName);
        }
        catch (JMSException e) {
            throw new JMSBindingException("Exception retreiving operation name from message", (Throwable)e);
        }
    }

    @Override
    public void setOperationName(String operationName, Message message) {
        try {
            if (message != null) {
                message.setStringProperty(this.operationPropertyName, operationName);
            }
        }
        catch (JMSException e) {
            throw new JMSBindingException("Exception setting the operation name on message", (Throwable)e);
        }
    }

    @Override
    public Message insertPayloadIntoJMSMessage(Session session, Object o) {
        return this.createJMSMessage(session, o);
    }

    @Override
    public Object extractPayloadFromJMSMessage(Message msg) {
        try {
            if (msg.getBooleanProperty("org_apache_tuscany_sca_fault")) {
                Serializable exc = ((ObjectMessage)msg).getObject();
                if (exc instanceof RuntimeException) {
                    throw new ServiceRuntimeException("remote service exception, see nested exception", (Throwable)exc);
                }
                return new InvocationTargetException((Throwable)exc);
            }
        }
        catch (JMSException e) {
            throw new JMSBindingException((Throwable)e);
        }
        return this.extractPayload(msg);
    }

    @Override
    public Message createFaultMessage(Session session, Throwable o) {
        if (session == null) {
            logger.fine("no response session to create fault message: " + String.valueOf(o));
            return null;
        }
        try {
            ObjectMessage message = session.createObjectMessage();
            if (o instanceof RuntimeException || o instanceof Error) {
                int recursionKlugeDetector = 20;
                Throwable rootCause = o;
                Throwable deepRootCause = rootCause.getCause();
                while (rootCause != deepRootCause) {
                    if (deepRootCause != null) {
                        rootCause = deepRootCause;
                    }
                    if (recursionKlugeDetector-- > 0 && deepRootCause != null) continue;
                }
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                pw.print("Message = " + o.getClass().getName() + ": " + o.getMessage());
                StackTraceElement[] stackElements = o.getStackTrace();
                for (int i = 0; i < stackElements.length; ++i) {
                    pw.print("\t>> \t at ");
                    pw.println(stackElements[i].toString());
                }
                pw.flush();
                message.setObject((Serializable)new RuntimeException(sw.toString()));
            } else {
                message.setObject((Serializable)o);
            }
            message.setBooleanProperty("org_apache_tuscany_sca_fault", true);
            return message;
        }
        catch (JMSException e) {
            throw new JMSBindingException((Throwable)e);
        }
    }

    protected abstract Object extractPayload(Message var1);

    protected abstract Message createJMSMessage(Session var1, Object var2);
}

