/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.host;

import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.naming.NamingException;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.binding.jms.JMSBinding;
import org.apache.tuscany.sca.binding.jms.context.JMSBindingContext;
import org.apache.tuscany.sca.binding.jms.provider.JMSResourceFactory;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;

public class DefaultServiceInvoker
implements MessageListener {
    private static final Logger logger = Logger.getLogger(DefaultServiceInvoker.class.getName());
    private RuntimeEndpoint endpoint;
    private JMSBinding jmsBinding;
    private Binding targetBinding;
    private JMSResourceFactory jmsResourceFactory;
    private RuntimeComponentService service;
    private MessageFactory messageFactory;

    public DefaultServiceInvoker(RuntimeEndpoint endpoint, Binding targetBinding, MessageFactory messageFactory, JMSResourceFactory rf) throws NamingException {
        this.endpoint = endpoint;
        this.jmsBinding = (JMSBinding)endpoint.getBinding();
        this.jmsResourceFactory = rf;
        this.service = (RuntimeComponentService)endpoint.getService();
        this.targetBinding = targetBinding;
        this.messageFactory = messageFactory;
    }

    public void onMessage(javax.jms.Message requestJMSMsg) {
        logger.log(Level.FINE, "JMS service '" + this.service.getName() + "' received message " + requestJMSMsg);
        try {
            this.invokeService(requestJMSMsg);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Exception send fault response '" + this.service.getName(), e);
        }
    }

    protected void invokeService(javax.jms.Message requestJMSMsg) throws JMSException, InvocationTargetException {
        Message tuscanyMsg = this.messageFactory.createMessage();
        JMSBindingContext context = new JMSBindingContext();
        tuscanyMsg.setBindingContext((Object)context);
        context.setJmsMsg(requestJMSMsg);
        context.setJmsResourceFactory(this.jmsResourceFactory);
        context.setReplyToDestination(requestJMSMsg.getJMSReplyTo());
        tuscanyMsg.setBody((Object)requestJMSMsg);
        RuntimeEndpoint endpoint = this.getEndpoint(this.targetBinding);
        if (endpoint.isAsyncInvocation()) {
            endpoint.invokeAsync(tuscanyMsg);
        } else {
            endpoint.invoke(tuscanyMsg);
        }
    }

    private RuntimeEndpoint getEndpoint(Binding targetBinding) {
        for (Endpoint ep : this.service.getEndpoints()) {
            if (ep.getBinding() != targetBinding) continue;
            return (RuntimeEndpoint)ep;
        }
        return this.endpoint;
    }
}

