/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.host;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import javax.naming.NamingException;
import javax.resource.spi.ActivationSpec;
import org.apache.tuscany.sca.binding.jms.JMSBinding;
import org.apache.tuscany.sca.binding.jms.JMSBindingException;
import org.apache.tuscany.sca.binding.jms.host.JMSServiceListener;
import org.apache.tuscany.sca.binding.jms.provider.JMSResourceFactory;
import org.apache.tuscany.sca.work.WorkScheduler;

public class AsyncResponseJMSServiceListener
implements JMSServiceListener {
    private static final Logger logger = Logger.getLogger(AsyncResponseJMSServiceListener.class.getName());
    private MessageListener listener;
    private String serviceName;
    private JMSBinding jmsBinding;
    private WorkScheduler workScheduler;
    private JMSResourceFactory jmsResourceFactory;
    private MessageConsumer consumer;
    private boolean running;
    private Destination destination;

    public AsyncResponseJMSServiceListener(MessageListener listener, String serviceName, JMSBinding jmsBinding, WorkScheduler workScheduler, JMSResourceFactory rf) {
        this.listener = listener;
        this.serviceName = serviceName;
        this.jmsBinding = jmsBinding;
        this.workScheduler = workScheduler;
        this.jmsResourceFactory = rf;
    }

    @Override
    public void start() {
        this.running = true;
        try {
            this.registerListener();
        }
        catch (Exception e) {
            if (e instanceof JMSBindingException) {
                throw (JMSBindingException)e;
            }
            throw new JMSBindingException("Error starting JMSAsyncResponse endpoint", (Throwable)e);
        }
    }

    @Override
    public void stop() {
        block2: {
            this.running = false;
            try {
                this.consumer.close();
                this.jmsResourceFactory.closeConnection();
                this.jmsResourceFactory.closeResponseConnection();
            }
            catch (Exception e) {
                if (e.getMessage() != null && e.getMessage().contains("disposed")) break block2;
                throw new JMSBindingException("Error stopping JMSServiceBinding", (Throwable)e);
            }
        }
    }

    private void registerListener() throws NamingException, JMSException {
        Session session = this.jmsResourceFactory.createSession();
        this.lookupActivationSpec();
        this.destination = this.lookupQueue(this.jmsBinding.getResponseDestinationName());
        if (this.destination == null) {
            throw new JMSBindingException("Unable to create Async Response queue");
        }
        this.consumer = this.jmsBinding.getJMSSelector() != null ? session.createConsumer(this.destination, this.jmsBinding.getJMSSelector()) : session.createConsumer(this.destination);
        try {
            this.consumer.setMessageListener(this.listener);
            this.jmsResourceFactory.startConnection();
        }
        catch (JMSException e) {
            this.jmsResourceFactory.startConnection();
            this.workScheduler.scheduleWork(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (AsyncResponseJMSServiceListener.this.running) {
                            final Message msg = AsyncResponseJMSServiceListener.this.consumer.receive();
                            AsyncResponseJMSServiceListener.this.workScheduler.scheduleWork(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        AsyncResponseJMSServiceListener.this.listener.onMessage(msg);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        logger.log(Level.INFO, "JMS AsyncResponse handler '" + this.serviceName + "' listening on destination " + (this.destination instanceof Queue ? ((Queue)this.destination).getQueueName() : ((Topic)this.destination).getTopicName()));
    }

    private void lookupActivationSpec() {
        if (this.jmsBinding.getActivationSpecName() != null) {
            ActivationSpec spec;
            String createMode = this.jmsBinding.getActivationSpecCreate();
            if ("always".equals(createMode)) {
                ActivationSpec spec2 = this.jmsResourceFactory.lookupActivationSpec(this.jmsBinding.getActivationSpecName());
                if (spec2 != null) {
                    throw new JMSBindingException("ActivationSpec specifies create mode of \"always\" but resource already exists.");
                }
                throw new JMSBindingException("Can not create ActivationSpec");
            }
            if ("ifNotExist".equals(createMode)) {
                ActivationSpec spec3 = this.jmsResourceFactory.lookupActivationSpec(this.jmsBinding.getActivationSpecName());
                if (spec3 == null) {
                    throw new JMSBindingException("Can not create ActivationSpec");
                }
            } else if ("never".equals(createMode) && (spec = this.jmsResourceFactory.lookupActivationSpec(this.jmsBinding.getActivationSpecName())) == null) {
                throw new JMSBindingException("ActivationSpec specifies create mode of \"never\" but resource does not exist at jndiName " + this.jmsBinding.getActivationSpecName());
            }
        }
    }

    private Destination lookupQueue(String queueName) throws NamingException, JMSBindingException {
        String type;
        Destination destination = this.jmsResourceFactory.lookupDestination(queueName);
        String qCreateMode = this.jmsBinding.getDestinationCreate();
        if (qCreateMode.equals("always")) {
            if (destination != null) {
                throw new JMSBindingException("JMS Destination " + queueName + " already exists but has create mode of \"" + qCreateMode + "\" while registering service " + this.serviceName + " listener");
            }
            destination = this.jmsResourceFactory.createDestination(queueName);
        } else if (qCreateMode.equals("ifNotExist")) {
            if (destination == null && !"jndi".equals(this.jmsBinding.getDestinationType())) {
                destination = this.jmsResourceFactory.createDestination(queueName);
            }
        } else if (qCreateMode.equals("never") && destination == null) {
            throw new JMSBindingException("JMS Destination " + queueName + " not found but create mode of \"" + qCreateMode + "\" while registering service " + this.serviceName + " listener");
        }
        if (destination == null) {
            throw new JMSBindingException("JMS Destination " + queueName + " not found with create mode of \"" + qCreateMode + "\" while registering service " + this.serviceName + " listener");
        }
        String string = type = destination instanceof Queue ? "queue" : "topic";
        if ("jndi".equals(this.jmsBinding.getDestinationType())) {
            this.jmsBinding.setDestinationType(type);
        } else if (!type.equals(this.jmsBinding.getDestinationType())) {
            throw new JMSBindingException("JMS Destination " + queueName + " expecting type of " + this.jmsBinding.getDestinationType() + " but found " + type + " while registering service " + this.serviceName + " listener");
        }
        return destination;
    }

    @Override
    public String getDestinationName() {
        try {
            if (this.destination instanceof Queue) {
                return ((Queue)this.destination).getQueueName();
            }
            if (this.destination instanceof Topic) {
                return ((Topic)this.destination).getTopicName();
            }
            return null;
        }
        catch (JMSException e) {
            throw new JMSBindingException((Throwable)e);
        }
    }
}

