/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.headers;

import java.util.Map;
import javax.jms.JMSException;
import org.apache.tuscany.sca.binding.jms.JMSBinding;
import org.apache.tuscany.sca.binding.jms.JMSBindingException;
import org.apache.tuscany.sca.binding.jms.provider.JMSMessageProcessor;
import org.apache.tuscany.sca.binding.jms.provider.JMSMessageProcessorUtil;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.invocation.InterceptorAsyncImpl;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;

public class HeaderServiceInterceptor
extends InterceptorAsyncImpl {
    private Invoker next;
    private JMSBinding jmsBinding;
    private JMSMessageProcessor responseMessageProcessor;

    public HeaderServiceInterceptor(ExtensionPointRegistry extensions, JMSBinding jmsBinding) {
        this.jmsBinding = jmsBinding;
        this.responseMessageProcessor = JMSMessageProcessorUtil.getResponseMessageProcessor(extensions, jmsBinding);
    }

    public Message invoke(Message msg) {
        msg = this.invokeRequest(msg);
        return this.invokeResponse(this.next.invoke(msg));
    }

    public Message invokeRequest(Message tuscanyMsg) {
        try {
            javax.jms.Message jmsMsg = (javax.jms.Message)tuscanyMsg.getBody();
            String msgID = (String)jmsMsg.getObjectProperty("MESSAGE_ID");
            if (msgID != null) {
                tuscanyMsg.getHeaders().put("MESSAGE_ID", msgID);
            }
        }
        catch (JMSException e) {
            throw new JMSBindingException((Throwable)e);
        }
        return tuscanyMsg;
    }

    public Message invokeResponse(Message tuscanyMsg) {
        try {
            String relatesTo;
            javax.jms.Message jmsMsg = (javax.jms.Message)tuscanyMsg.getBody();
            Operation operation = tuscanyMsg.getOperation();
            String operationName = operation.getName();
            this.responseMessageProcessor.setOperationName(operationName, jmsMsg);
            for (String propName : this.jmsBinding.getPropertyNames()) {
                Object value = this.jmsBinding.getProperty(propName);
                jmsMsg.setObjectProperty(propName, value);
            }
            Map operationProperties = this.jmsBinding.getOperationProperties(operationName);
            if (operationProperties != null) {
                for (String propName : operationProperties.keySet()) {
                    Object value = operationProperties.get(propName);
                    jmsMsg.setObjectProperty(propName, value);
                }
            }
            if ((relatesTo = (String)tuscanyMsg.getHeaders().get("RELATES_TO")) != null) {
                jmsMsg.setStringProperty("RELATES_TO", relatesTo);
            }
            return tuscanyMsg;
        }
        catch (JMSException e) {
            throw new JMSBindingException((Throwable)e);
        }
    }

    public Invoker getNext() {
        return this.next;
    }

    public void setNext(Invoker next) {
        this.next = next;
    }

    public Message processRequest(Message msg) {
        return this.invokeRequest(msg);
    }

    public Message processResponse(Message msg) {
        return this.invokeResponse(msg);
    }
}

