/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.wireformat.jmstextxml.runtime;

import javax.jms.Session;
import org.apache.tuscany.sca.binding.jms.JMSBinding;
import org.apache.tuscany.sca.binding.jms.context.JMSBindingContext;
import org.apache.tuscany.sca.binding.jms.provider.JMSMessageProcessor;
import org.apache.tuscany.sca.binding.jms.provider.JMSMessageProcessorUtil;
import org.apache.tuscany.sca.binding.jms.provider.JMSResourceFactory;
import org.apache.tuscany.sca.binding.jms.wireformat.WireFormatJMSTextXML;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.invocation.InterceptorAsyncImpl;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;

public class WireFormatJMSTextXMLServiceInterceptor
extends InterceptorAsyncImpl {
    private Invoker next;
    private RuntimeEndpoint endpoint;
    private JMSResourceFactory jmsResourceFactory;
    private JMSBinding jmsBinding;
    private JMSMessageProcessor requestMessageProcessor;
    private JMSMessageProcessor responseMessageProcessor;

    public WireFormatJMSTextXMLServiceInterceptor(ExtensionPointRegistry registry, JMSResourceFactory jmsResourceFactory, RuntimeEndpoint endpoint) {
        this.jmsBinding = (JMSBinding)endpoint.getBinding();
        this.endpoint = endpoint;
        this.jmsResourceFactory = jmsResourceFactory;
        this.requestMessageProcessor = JMSMessageProcessorUtil.getRequestMessageProcessor(registry, this.jmsBinding);
        this.responseMessageProcessor = JMSMessageProcessorUtil.getResponseMessageProcessor(registry, this.jmsBinding);
    }

    public Message invoke(Message msg) {
        Operation operation;
        if (this.jmsBinding.getRequestWireFormat() instanceof WireFormatJMSTextXML) {
            msg = this.invokeRequest(msg);
        }
        if ((operation = (msg = this.getNext().invoke(msg)).getOperation()) != null && operation.isNonBlocking()) {
            return msg;
        }
        if (this.jmsBinding.getResponseWireFormat() instanceof WireFormatJMSTextXML) {
            msg = this.invokeResponse(msg);
        }
        return msg;
    }

    public Message invokeRequest(Message msg) {
        JMSBindingContext context = (JMSBindingContext)msg.getBindingContext();
        javax.jms.Message jmsMsg = context.getJmsMsg();
        Object requestPayload = this.requestMessageProcessor.extractPayloadFromJMSMessage(jmsMsg);
        msg.setBody((Object)new Object[]{requestPayload});
        return msg;
    }

    public Message invokeResponse(Message msg) {
        JMSBindingContext context = (JMSBindingContext)msg.getBindingContext();
        if (context == null) {
            context = this.createBindingContext();
            msg.setBindingContext((Object)context);
        }
        Session session = context.getJmsResponseSession();
        javax.jms.Message responseJMSMsg = msg.isFault() ? this.responseMessageProcessor.createFaultMessage(session, (Throwable)msg.getBody()) : this.responseMessageProcessor.insertPayloadIntoJMSMessage(session, msg.getBody());
        msg.setBody((Object)responseJMSMsg);
        return msg;
    }

    public Invoker getNext() {
        return this.next;
    }

    public void setNext(Invoker next) {
        this.next = next;
    }

    private JMSBindingContext createBindingContext() {
        JMSBindingContext context = new JMSBindingContext();
        context.setJmsResourceFactory(this.jmsResourceFactory);
        return context;
    }

    public Message processRequest(Message msg) {
        return this.invokeRequest(msg);
    }

    public Message processResponse(Message msg) {
        return this.invokeResponse(msg);
    }
}

