/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.wireformat.jmstextxml.runtime;

import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.Contract;
import org.apache.tuscany.sca.binding.jms.JMSBinding;
import org.apache.tuscany.sca.binding.jms.provider.xml.XMLHelperFactory;
import org.apache.tuscany.sca.binding.jms.wireformat.WireFormatJMSTextXML;
import org.apache.tuscany.sca.binding.jms.wireformat.jmstextxml.runtime.WireFormatJMSTextXMLReferenceInterceptor;
import org.apache.tuscany.sca.binding.ws.WebServiceBinding;
import org.apache.tuscany.sca.binding.ws.WebServiceBindingFactory;
import org.apache.tuscany.sca.binding.ws.wsdlgen.BindingWSDLGenerator;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.provider.WireFormatProvider;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;

public class WireFormatJMSTextXMLReferenceProvider
implements WireFormatProvider {
    private ExtensionPointRegistry registry;
    private RuntimeEndpointReference endpointReference;
    private JMSBinding binding;
    private InterfaceContract interfaceContract;

    public WireFormatJMSTextXMLReferenceProvider(ExtensionPointRegistry registry, RuntimeEndpointReference endpointReference) {
        this.registry = registry;
        this.endpointReference = endpointReference;
        this.binding = (JMSBinding)endpointReference.getBinding();
        if (this.binding.getRequestWireFormat() instanceof WireFormatJMSTextXML) {
            this.binding.setRequestMessageProcessorName("org.apache.tuscany.sca.binding.jms.provider.XMLTextMessageProcessor");
        }
        if (this.binding.getResponseWireFormat() instanceof WireFormatJMSTextXML) {
            this.binding.setResponseMessageProcessorName("org.apache.tuscany.sca.binding.jms.provider.XMLTextMessageProcessor");
        }
        WebServiceBindingFactory wsFactory = (WebServiceBindingFactory)registry.getExtensionPoint(WebServiceBindingFactory.class);
        WebServiceBinding wsBinding = wsFactory.createWebServiceBinding();
        BindingWSDLGenerator.generateWSDL((Component)endpointReference.getComponent(), (Contract)endpointReference.getReference(), (WebServiceBinding)wsBinding, (ExtensionPointRegistry)registry, null);
        this.interfaceContract = wsBinding.getBindingInterfaceContract();
        this.interfaceContract.getInterface().resetDataBinding(XMLHelperFactory.createXMLHelper(registry).getDataBindingName());
    }

    protected boolean isOnMessage() {
        InterfaceContract ic = this.endpointReference.getReference().getInterfaceContract();
        if (ic.getInterface().getOperations().size() != 1) {
            return false;
        }
        return "onMessage".equals(((Operation)ic.getInterface().getOperations().get(0)).getName());
    }

    public InterfaceContract configureWireFormatInterfaceContract(InterfaceContract interfaceContract) {
        if (this.interfaceContract != null && !this.isOnMessage()) {
            if (this.binding.getRequestWireFormat() instanceof WireFormatJMSTextXML) {
                interfaceContract.getInterface().resetInterfaceInputTypes(this.interfaceContract.getInterface());
            }
            if (this.binding.getResponseWireFormat() instanceof WireFormatJMSTextXML) {
                interfaceContract.getInterface().resetInterfaceOutputTypes(this.interfaceContract.getInterface());
            }
        }
        return interfaceContract;
    }

    public Interceptor createInterceptor() {
        return new WireFormatJMSTextXMLReferenceInterceptor(this.registry, null, this.endpointReference);
    }

    public String getPhase() {
        return "reference.binding.wireformat";
    }

    public InterfaceContract getWireFormatInterfaceContract() {
        return this.interfaceContract;
    }
}

