/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.wireformat.jmstextxml.runtime;

import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.tuscany.sca.binding.jms.JMSBinding;
import org.apache.tuscany.sca.binding.jms.JMSBindingException;
import org.apache.tuscany.sca.binding.jms.context.JMSBindingContext;
import org.apache.tuscany.sca.binding.jms.provider.JMSMessageProcessor;
import org.apache.tuscany.sca.binding.jms.provider.JMSMessageProcessorUtil;
import org.apache.tuscany.sca.binding.jms.provider.JMSResourceFactory;
import org.apache.tuscany.sca.binding.jms.provider.xml.XMLHelper;
import org.apache.tuscany.sca.binding.jms.provider.xml.XMLHelperFactory;
import org.apache.tuscany.sca.binding.jms.wireformat.WireFormatJMSTextXML;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.invocation.InterceptorAsyncImpl;
import org.apache.tuscany.sca.interfacedef.util.FaultException;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;

public class WireFormatJMSTextXMLReferenceInterceptor
extends InterceptorAsyncImpl {
    private Invoker next;
    private RuntimeEndpointReference endpointReference;
    private JMSResourceFactory jmsResourceFactory;
    private JMSBinding jmsBinding;
    private JMSMessageProcessor requestMessageProcessor;
    private JMSMessageProcessor responseMessageProcessor;
    private XMLHelper<?> xmlhelper;

    public WireFormatJMSTextXMLReferenceInterceptor(ExtensionPointRegistry registry, JMSResourceFactory jmsResourceFactory, RuntimeEndpointReference endpointReference) {
        this.jmsBinding = (JMSBinding)endpointReference.getBinding();
        this.endpointReference = endpointReference;
        this.jmsResourceFactory = jmsResourceFactory;
        this.requestMessageProcessor = JMSMessageProcessorUtil.getRequestMessageProcessor(registry, this.jmsBinding);
        this.responseMessageProcessor = JMSMessageProcessorUtil.getResponseMessageProcessor(registry, this.jmsBinding);
        this.xmlhelper = XMLHelperFactory.createXMLHelper(registry);
    }

    public Message invoke(Message msg) {
        if (this.jmsBinding.getRequestWireFormat() instanceof WireFormatJMSTextXML) {
            msg = this.invokeRequest(msg);
        }
        msg = this.getNext().invoke(msg);
        if (this.jmsBinding.getResponseWireFormat() instanceof WireFormatJMSTextXML) {
            msg = this.invokeResponse(msg);
        }
        return msg;
    }

    public Message invokeRequest(Message msg) {
        try {
            JMSBindingContext context = (JMSBindingContext)msg.getBindingContext();
            Session session = context.getJmsSession();
            javax.jms.Message requestMsg = this.requestMessageProcessor.insertPayloadIntoJMSMessage(session, msg.getBody());
            msg.setBody((Object)requestMsg);
            requestMsg.setJMSReplyTo(context.getReplyToDestination());
            return msg;
        }
        catch (JMSException e) {
            throw new JMSBindingException((Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Message invokeResponse(Message msg) {
        if (msg.getBody() == null) return msg;
        javax.jms.Message jmsMsg = (javax.jms.Message)msg.getBody();
        Object response = this.responseMessageProcessor.extractPayloadFromJMSMessage(jmsMsg);
        if (response != null) {
            msg.setBody(response);
            try {
                if (!jmsMsg.getBooleanProperty("org_apache_tuscany_sca_fault")) return msg;
                FaultException e = new FaultException("remote exception", response);
                this.xmlhelper.setFaultName(e, response);
                msg.setFaultBody((Object)e);
                return msg;
            }
            catch (JMSException e) {
                throw new JMSBindingException((Throwable)e);
            }
        } else {
            msg.setBody(null);
        }
        return msg;
    }

    public Invoker getNext() {
        return this.next;
    }

    public void setNext(Invoker next) {
        this.next = next;
    }

    public Message processRequest(Message msg) {
        return this.invokeRequest(msg);
    }

    public Message processResponse(Message msg) {
        return this.invokeResponse(msg);
    }
}

