/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.wireformat.jmstext.runtime;

import org.apache.tuscany.sca.binding.jms.JMSBinding;
import org.apache.tuscany.sca.binding.jms.provider.JMSResourceFactory;
import org.apache.tuscany.sca.binding.jms.wireformat.WireFormatJMSText;
import org.apache.tuscany.sca.binding.jms.wireformat.jmstext.runtime.WireFormatJMSTextServiceInterceptor;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.provider.WireFormatProvider;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;

public class WireFormatJMSTextServiceProvider
implements WireFormatProvider {
    private ExtensionPointRegistry registry;
    private RuntimeEndpoint endpoint;
    private JMSBinding binding;
    private InterfaceContract interfaceContract;
    private JMSResourceFactory jmsResourceFactory;

    public WireFormatJMSTextServiceProvider(ExtensionPointRegistry registry, RuntimeEndpoint endpoint, JMSResourceFactory jmsResourceFactory) {
        this.registry = registry;
        this.endpoint = endpoint;
        this.jmsResourceFactory = jmsResourceFactory;
        this.binding = (JMSBinding)endpoint.getBinding();
        if (this.binding.getRequestWireFormat() instanceof WireFormatJMSText && this.binding.getRequestMessageProcessorName().equals("org.apache.tuscany.sca.binding.jms.provider.DefaultMessageProcessor")) {
            this.binding.setRequestMessageProcessorName("org.apache.tuscany.sca.binding.jms.provider.TextMessageProcessor");
        }
        if (this.binding.getResponseWireFormat() instanceof WireFormatJMSText && this.binding.getResponseMessageProcessorName().equals("org.apache.tuscany.sca.binding.jms.provider.DefaultMessageProcessor")) {
            this.binding.setResponseMessageProcessorName("org.apache.tuscany.sca.binding.jms.provider.TextMessageProcessor");
        }
        this.interfaceContract = endpoint.getService().getService().getInterfaceContract();
    }

    public InterfaceContract configureWireFormatInterfaceContract(InterfaceContract interfaceContract) {
        if (this.interfaceContract != null) {
            if (this.binding.getRequestWireFormat() instanceof WireFormatJMSText) {
                interfaceContract.getInterface().resetInterfaceInputTypes(this.interfaceContract.getInterface());
            }
            if (this.binding.getResponseWireFormat() instanceof WireFormatJMSText) {
                interfaceContract.getInterface().resetInterfaceOutputTypes(this.interfaceContract.getInterface());
            }
        }
        return interfaceContract;
    }

    public Interceptor createInterceptor() {
        return new WireFormatJMSTextServiceInterceptor(this.registry, this.jmsResourceFactory, this.endpoint);
    }

    public String getPhase() {
        return "service.binding.wireformat";
    }

    public InterfaceContract getWireFormatInterfaceContract() {
        return this.interfaceContract;
    }
}

