/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.wireformat.jmsbytes.runtime;

import org.apache.tuscany.sca.binding.jms.JMSBinding;
import org.apache.tuscany.sca.binding.jms.provider.JMSResourceFactory;
import org.apache.tuscany.sca.binding.jms.wireformat.WireFormatJMSBytes;
import org.apache.tuscany.sca.binding.jms.wireformat.jmsbytes.runtime.WireFormatJMSBytesServiceInterceptor;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.provider.WireFormatProvider;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;

public class WireFormatJMSBytesServiceProvider
implements WireFormatProvider {
    private ExtensionPointRegistry registry;
    private RuntimeEndpoint endpoint;
    private JMSBinding binding;
    private InterfaceContract interfaceContract;
    private JMSResourceFactory jmsResourceFactory;

    public WireFormatJMSBytesServiceProvider(ExtensionPointRegistry registry, RuntimeEndpoint endpoint, JMSResourceFactory jmsResourceFactory) {
        this.registry = registry;
        this.endpoint = endpoint;
        this.endpoint = endpoint;
        this.jmsResourceFactory = jmsResourceFactory;
        this.binding = (JMSBinding)endpoint.getBinding();
        if (this.binding.getRequestWireFormat() instanceof WireFormatJMSBytes) {
            this.binding.setRequestMessageProcessorName("org.apache.tuscany.sca.binding.jms.provider.BytesMessageProcessor");
        }
        if (this.binding.getResponseWireFormat() instanceof WireFormatJMSBytes) {
            this.binding.setResponseMessageProcessorName("org.apache.tuscany.sca.binding.jms.provider.BytesMessageProcessor");
        }
        this.interfaceContract = endpoint.getService().getService().getInterfaceContract();
    }

    public InterfaceContract configureWireFormatInterfaceContract(InterfaceContract interfaceContract) {
        if (this.interfaceContract != null) {
            if (this.binding.getRequestWireFormat() instanceof WireFormatJMSBytes) {
                interfaceContract.getInterface().resetInterfaceInputTypes(this.interfaceContract.getInterface());
            }
            if (this.binding.getResponseWireFormat() instanceof WireFormatJMSBytes) {
                interfaceContract.getInterface().resetInterfaceOutputTypes(this.interfaceContract.getInterface());
            }
        }
        return interfaceContract;
    }

    public Interceptor createInterceptor() {
        return new WireFormatJMSBytesServiceInterceptor(this.registry, this.jmsResourceFactory, this.endpoint);
    }

    public String getPhase() {
        return "service.binding.wireformat";
    }

    public InterfaceContract getWireFormatInterfaceContract() {
        return this.interfaceContract;
    }
}

