/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.wireformat.jmsbytes.runtime;

import org.apache.tuscany.sca.binding.jms.JMSBinding;
import org.apache.tuscany.sca.binding.jms.wireformat.WireFormatJMSBytes;
import org.apache.tuscany.sca.binding.jms.wireformat.jmsbytes.runtime.WireFormatJMSBytesReferenceInterceptor;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.provider.WireFormatProvider;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;

public class WireFormatJMSBytesReferenceProvider
implements WireFormatProvider {
    private ExtensionPointRegistry registry;
    private RuntimeEndpointReference endpointReference;
    private JMSBinding binding;
    private InterfaceContract interfaceContract;

    public WireFormatJMSBytesReferenceProvider(ExtensionPointRegistry registry, RuntimeEndpointReference endpointReference) {
        this.registry = registry;
        this.endpointReference = endpointReference;
        this.binding = (JMSBinding)endpointReference.getBinding();
        if (this.binding.getRequestWireFormat() instanceof WireFormatJMSBytes) {
            this.binding.setRequestMessageProcessorName("org.apache.tuscany.sca.binding.jms.provider.BytesMessageProcessor");
        }
        if (this.binding.getResponseWireFormat() instanceof WireFormatJMSBytes) {
            this.binding.setResponseMessageProcessorName("org.apache.tuscany.sca.binding.jms.provider.BytesMessageProcessor");
        }
        this.interfaceContract = endpointReference.getReference().getReference().getInterfaceContract();
    }

    public InterfaceContract configureWireFormatInterfaceContract(InterfaceContract interfaceContract) {
        if (this.interfaceContract != null) {
            if (this.binding.getRequestWireFormat() instanceof WireFormatJMSBytes) {
                interfaceContract.getInterface().resetInterfaceInputTypes(this.interfaceContract.getInterface());
            }
            if (this.binding.getResponseWireFormat() instanceof WireFormatJMSBytes) {
                interfaceContract.getInterface().resetInterfaceOutputTypes(this.interfaceContract.getInterface());
            }
        }
        return interfaceContract;
    }

    public Interceptor createInterceptor() {
        return new WireFormatJMSBytesReferenceInterceptor(this.registry, null, this.endpointReference);
    }

    public String getPhase() {
        return "reference.binding.wireformat";
    }

    public InterfaceContract getWireFormatInterfaceContract() {
        return this.interfaceContract;
    }
}

