/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.wireformat.jmsbytes.runtime;

import java.lang.reflect.InvocationTargetException;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.tuscany.sca.binding.jms.JMSBinding;
import org.apache.tuscany.sca.binding.jms.JMSBindingException;
import org.apache.tuscany.sca.binding.jms.context.JMSBindingContext;
import org.apache.tuscany.sca.binding.jms.provider.JMSMessageProcessor;
import org.apache.tuscany.sca.binding.jms.provider.JMSMessageProcessorUtil;
import org.apache.tuscany.sca.binding.jms.provider.JMSResourceFactory;
import org.apache.tuscany.sca.binding.jms.wireformat.WireFormatJMSBytes;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.invocation.InterceptorAsyncImpl;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;

public class WireFormatJMSBytesReferenceInterceptor
extends InterceptorAsyncImpl {
    private Invoker next;
    private RuntimeEndpointReference endpointReference;
    private JMSResourceFactory jmsResourceFactory;
    private JMSBinding jmsBinding;
    private JMSMessageProcessor requestMessageProcessor;
    private JMSMessageProcessor responseMessageProcessor;

    public WireFormatJMSBytesReferenceInterceptor(ExtensionPointRegistry registry, JMSResourceFactory jmsResourceFactory, RuntimeEndpointReference endpointReference) {
        this.endpointReference = endpointReference;
        this.jmsBinding = (JMSBinding)endpointReference.getBinding();
        this.jmsResourceFactory = jmsResourceFactory;
        this.requestMessageProcessor = JMSMessageProcessorUtil.getRequestMessageProcessor(registry, this.jmsBinding);
        this.responseMessageProcessor = JMSMessageProcessorUtil.getResponseMessageProcessor(registry, this.jmsBinding);
    }

    public Message invoke(Message msg) {
        if (this.jmsBinding.getRequestWireFormat() instanceof WireFormatJMSBytes) {
            msg = this.invokeRequest(msg);
        }
        msg = this.getNext().invoke(msg);
        if (this.jmsBinding.getResponseWireFormat() instanceof WireFormatJMSBytes) {
            msg = this.invokeResponse(msg);
        }
        return msg;
    }

    public Message invokeRequest(Message msg) {
        try {
            JMSBindingContext context = (JMSBindingContext)msg.getBindingContext();
            Session session = context.getJmsSession();
            Object[] requestParams = (Object[])msg.getBody();
            javax.jms.Message requestMsg = null;
            requestMsg = requestParams != null && requestParams.length > 0 ? this.requestMessageProcessor.insertPayloadIntoJMSMessage(session, requestParams[0]) : this.requestMessageProcessor.insertPayloadIntoJMSMessage(session, null);
            msg.setBody((Object)requestMsg);
            requestMsg.setJMSReplyTo(context.getReplyToDestination());
            return msg;
        }
        catch (JMSException e) {
            throw new JMSBindingException((Throwable)e);
        }
    }

    public Message invokeResponse(Message msg) {
        if (msg.getBody() != null) {
            Object response = this.responseMessageProcessor.extractPayloadFromJMSMessage((javax.jms.Message)msg.getBody());
            if (response instanceof InvocationTargetException) {
                msg.setFaultBody((Object)((InvocationTargetException)response).getCause());
            } else if (response != null) {
                msg.setBody(response);
            } else {
                msg.setBody(null);
            }
        }
        return msg;
    }

    public Invoker getNext() {
        return this.next;
    }

    public void setNext(Invoker next) {
        this.next = next;
    }

    public Message processRequest(Message msg) {
        return this.invokeRequest(msg);
    }

    public Message processResponse(Message msg) {
        return this.invokeResponse(msg);
    }
}

