/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.wire;

import java.util.List;
import org.apache.tuscany.sca.binding.jms.JMSBinding;
import org.apache.tuscany.sca.core.invocation.InterceptorAsyncImpl;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;

public class OperationPropertiesInterceptor
extends InterceptorAsyncImpl {
    private Invoker next;
    private JMSBinding jmsBinding;
    private RuntimeComponentService service;
    private List<Operation> serviceOperations;

    public OperationPropertiesInterceptor(JMSBinding jmsBinding, RuntimeEndpoint endpoint) {
        this.jmsBinding = jmsBinding;
        this.service = (RuntimeComponentService)endpoint.getService();
        this.serviceOperations = this.service.getInterfaceContract().getInterface().getOperations();
    }

    public Invoker getNext() {
        return this.next;
    }

    public void setNext(Invoker next) {
        this.next = next;
    }

    public Message invoke(Message msg) {
        return this.next.invoke(this.invokeRequest(msg));
    }

    public Message invokeRequest(Message msg) {
        String operationName = msg.getOperation().getName();
        String operationNameOverride = this.jmsBinding.getOpNameFromNativeOperationName(operationName);
        if (operationNameOverride != null) {
            for (Operation op : this.serviceOperations) {
                if (!op.getName().equals(operationNameOverride)) continue;
                msg.setOperation(op);
                break;
            }
        }
        return msg;
    }

    public Message processRequest(Message msg) {
        return this.invokeRequest(msg);
    }

    public Message processResponse(Message msg) {
        return msg;
    }
}

