/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.wire;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Topic;
import org.apache.tuscany.sca.binding.jms.JMSBindingException;
import org.apache.tuscany.sca.binding.jms.context.JMSBindingContext;
import org.apache.tuscany.sca.core.invocation.CallbackHandler;
import org.apache.tuscany.sca.core.invocation.InterceptorAsyncImpl;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;

public class CallbackDestinationInterceptor
extends InterceptorAsyncImpl {
    private Invoker next;
    private RuntimeComponentService service;
    private RuntimeEndpoint endpoint;

    public CallbackDestinationInterceptor(RuntimeEndpoint endpoint) {
        this.service = (RuntimeComponentService)endpoint.getService();
        this.endpoint = endpoint;
    }

    public Invoker getNext() {
        return this.next;
    }

    public void setNext(Invoker next) {
        this.next = next;
    }

    public Message invoke(Message msg) {
        return this.next.invoke(this.invokeRequest(msg));
    }

    public Message invokeRequest(Message msg) {
        try {
            Destination replyTo;
            JMSBindingContext context = (JMSBindingContext)msg.getBindingContext();
            javax.jms.Message jmsMsg = context.getJmsMsg();
            String callbackdestName = jmsMsg.getStringProperty("scaCallbackDestination");
            if (callbackdestName != null) {
                if (!callbackdestName.startsWith("jms:jndi:")) {
                    throw new JMSBindingException("message property scaCallbackDestination does not start with 'jms:jndi:' found: " + callbackdestName);
                }
                callbackdestName = "jms:queue:" + callbackdestName.substring(9);
            } else if (this.service.getInterfaceContract().getCallbackInterface() != null && jmsMsg.getJMSReplyTo() != null && msg.getOperation().isNonBlocking() && (replyTo = jmsMsg.getJMSReplyTo()) != null) {
                callbackdestName = replyTo instanceof Queue ? "jms:queue:" + ((Queue)replyTo).getQueueName() : "jms:topic:" + ((Topic)replyTo).getTopicName();
            }
            if (callbackdestName != null) {
                msg.getHeaders().put("CALLBACK", new CallbackHandler(callbackdestName));
            }
        }
        catch (JMSException e) {
            throw new JMSBindingException((Throwable)e);
        }
        return msg;
    }

    public Message processRequest(Message msg) {
        return this.invokeRequest(msg);
    }

    public Message processResponse(Message msg) {
        return msg;
    }
}

