/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.wire;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.naming.NamingException;
import org.apache.tuscany.sca.binding.jms.JMSBindingException;
import org.apache.tuscany.sca.binding.jms.context.JMSBindingContext;
import org.apache.tuscany.sca.binding.jms.provider.JMSResourceFactory;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.invocation.AsyncResponseInvoker;
import org.apache.tuscany.sca.core.invocation.InterceptorAsyncImpl;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;

public class AsyncResponseDestinationInterceptor
extends InterceptorAsyncImpl {
    private Invoker next;
    private RuntimeComponentService service;
    private RuntimeEndpoint endpoint;
    private ExtensionPointRegistry registry;

    public AsyncResponseDestinationInterceptor(RuntimeEndpoint endpoint, ExtensionPointRegistry registry) {
        this.service = (RuntimeComponentService)endpoint.getService();
        this.endpoint = endpoint;
        this.registry = registry;
    }

    public Invoker getNext() {
        return this.next;
    }

    public void setNext(Invoker next) {
        this.next = next;
    }

    public Message invoke(Message msg) {
        return this.next.invoke(this.invokeRequest(msg));
    }

    public Message invokeRequest(Message msg) {
        try {
            Destination replyTo;
            JMSBindingContext context = (JMSBindingContext)msg.getBindingContext();
            javax.jms.Message jmsMsg = context.getJmsMsg();
            String asyncRespAddr = jmsMsg.getStringProperty("scaCallbackDestination");
            if (asyncRespAddr != null) {
                asyncRespAddr = this.stripJMSPrefix(asyncRespAddr);
            } else if (this.isAsync(this.service) && jmsMsg.getJMSReplyTo() != null && (replyTo = jmsMsg.getJMSReplyTo()) != null) {
                String string = asyncRespAddr = replyTo instanceof Queue ? ((Queue)replyTo).getQueueName() : ((Topic)replyTo).getTopicName();
            }
            if (asyncRespAddr == null) {
                return msg;
            }
            String msgID = (String)msg.getHeaders().get("MESSAGE_ID");
            String operationName = msg.getOperation().getName();
            AsyncResponseInvoker respInvoker = new AsyncResponseInvoker(this.endpoint, null, (Object)asyncRespAddr, msgID, operationName, this.getMessageFactory());
            msg.getHeaders().put("ASYNC_RESPONSE_INVOKER", respInvoker);
        }
        catch (JMSException e) {
            throw new JMSBindingException((Throwable)e);
        }
        return msg;
    }

    public Message processRequest(Message msg) {
        return this.invokeRequest(msg);
    }

    public Message processResponse(Message msg) {
        Destination dest;
        AsyncResponseInvoker respInvoker = (AsyncResponseInvoker)msg.getHeaders().get("ASYNC_RESPONSE_INVOKER");
        if (respInvoker == null) {
            return msg;
        }
        String responseAddress = (String)respInvoker.getResponseTargetAddress();
        String relatedMsg = respInvoker.getRelatesToMsgID();
        JMSBindingContext context = (JMSBindingContext)msg.getBindingContext();
        JMSResourceFactory jmsResourceFactory = context.getJmsResourceFactory();
        try {
            dest = jmsResourceFactory.lookupDestination(responseAddress);
            if (dest == null) {
                dest = jmsResourceFactory.createDestination(responseAddress);
            }
        }
        catch (NamingException e) {
            throw new JMSBindingException((Throwable)e);
        }
        context.setReplyToDestination(dest);
        msg.getHeaders().put("RELATES_TO", relatedMsg);
        return msg;
    }

    private String stripJMSPrefix(String asyncRespAddr) {
        if (!asyncRespAddr.startsWith("jms:jndi:")) {
            throw new JMSBindingException("message property scaCallbackDestination does not start with 'jms:jndi:' found: " + asyncRespAddr);
        }
        return asyncRespAddr.substring(9);
    }

    private boolean isAsync(RuntimeComponentService service) {
        service.getInterfaceContract().getInterface();
        for (Intent intent : service.getRequiredIntents()) {
            if (!intent.getName().getLocalPart().equals("asyncInvocation")) continue;
            return true;
        }
        for (Intent intent : service.getInterfaceContract().getInterface().getRequiredIntents()) {
            if (!intent.getName().getLocalPart().equals("asyncInvocation")) continue;
            return true;
        }
        return false;
    }

    private MessageFactory getMessageFactory() {
        FactoryExtensionPoint modelFactories = (FactoryExtensionPoint)this.registry.getExtensionPoint(FactoryExtensionPoint.class);
        return (MessageFactory)modelFactories.getFactory(MessageFactory.class);
    }
}

