/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.transport;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.NamingException;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.binding.jms.JMSBinding;
import org.apache.tuscany.sca.binding.jms.JMSBindingException;
import org.apache.tuscany.sca.binding.jms.context.JMSBindingContext;
import org.apache.tuscany.sca.binding.jms.provider.JMSMessageProcessor;
import org.apache.tuscany.sca.binding.jms.provider.JMSMessageProcessorUtil;
import org.apache.tuscany.sca.binding.jms.provider.JMSResourceFactory;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.invocation.InterceptorAsyncImpl;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;

public class TransportServiceInterceptor
extends InterceptorAsyncImpl {
    private static final Logger logger = Logger.getLogger(TransportServiceInterceptor.class.getName());
    private Invoker next;
    private JMSResourceFactory jmsResourceFactory;
    private JMSBinding jmsBinding;
    private JMSMessageProcessor responseMessageProcessor;
    private RuntimeComponentService service;
    private String correlationScheme;
    private AssemblyFactory assemblyFactory;

    public TransportServiceInterceptor(ExtensionPointRegistry registry, JMSBinding jmsBinding, JMSResourceFactory jmsResourceFactory, RuntimeEndpoint endpoint) {
        this.jmsBinding = jmsBinding;
        this.jmsResourceFactory = jmsResourceFactory;
        this.responseMessageProcessor = JMSMessageProcessorUtil.getResponseMessageProcessor(registry, jmsBinding);
        this.service = (RuntimeComponentService)endpoint.getService();
        this.correlationScheme = jmsBinding.getCorrelationScheme();
        FactoryExtensionPoint factories = (FactoryExtensionPoint)registry.getExtensionPoint(FactoryExtensionPoint.class);
        this.assemblyFactory = (AssemblyFactory)factories.getFactory(AssemblyFactory.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Message invoke(Message msg) {
        Message message;
        try {
            message = this.invokeResponse(this.next.invoke(this.invokeRequest(msg)));
        }
        catch (Throwable e) {
            try {
                try {
                    logger.log(Level.SEVERE, "Exception invoking service '" + this.service.getName(), e);
                    Operation operation = msg.getOperation();
                    if (operation == null || !operation.isNonBlocking()) {
                        JMSBindingContext context = (JMSBindingContext)msg.getBindingContext();
                        Session session = context.getJmsResponseSession();
                        javax.jms.Message replyJMSMsg = this.responseMessageProcessor.createFaultMessage(session, e);
                        msg.setBody((Object)replyJMSMsg);
                        this.invokeResponse(msg);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (e instanceof Error) {
                    throw (Error)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                Message message2 = msg;
                return message2;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    try {
                        ((JMSBindingContext)msg.getBindingContext()).closeJmsResponseSession();
                    }
                    catch (Throwable e2) {}
                    JMSResourceFactory rf = ((JMSBindingContext)msg.getBindingContext()).getJmsResourceFactory();
                    if (rf.isConnectionClosedAfterUse()) {
                        rf.closeResponseConnection();
                    }
                }
                catch (JMSException e3) {}
            }
        }
        try {
            try {
                ((JMSBindingContext)msg.getBindingContext()).closeJmsResponseSession();
            }
            catch (Throwable e) {
                // empty catch block
            }
            JMSResourceFactory rf = ((JMSBindingContext)msg.getBindingContext()).getJmsResourceFactory();
            if (!rf.isConnectionClosedAfterUse()) return message;
            rf.closeResponseConnection();
            return message;
        }
        catch (JMSException e) {
            // empty catch block
        }
        return message;
    }

    public Message invokeRequest(Message msg) {
        EndpointReference from = this.assemblyFactory.createEndpointReference();
        Endpoint fromEndpoint = this.assemblyFactory.createEndpoint();
        from.setTargetEndpoint(fromEndpoint);
        from.setStatus(EndpointReference.Status.WIRED_TARGET_FOUND_AND_MATCHED);
        msg.setFrom(from);
        return msg;
    }

    public Message invokeResponse(Message msg) {
        JMSBindingContext context = (JMSBindingContext)msg.getBindingContext();
        try {
            Operation operation = msg.getOperation();
            if (operation != null && operation.isNonBlocking()) {
                Message message = msg;
                return message;
            }
            Session session = context.getJmsResponseSession();
            javax.jms.Message requestJMSMsg = context.getJmsMsg();
            javax.jms.Message responseJMSMsg = (javax.jms.Message)msg.getBody();
            Destination replyDest = requestJMSMsg.getJMSReplyTo();
            if (replyDest == null && this.jmsBinding.getResponseDestinationName() != null) {
                try {
                    replyDest = this.jmsResourceFactory.lookupDestination(this.jmsBinding.getResponseDestinationName());
                }
                catch (NamingException e) {
                    throw new JMSBindingException("Exception lookingup response destination", (Throwable)e);
                }
            }
            if (replyDest == null) {
                if (msg.getBody() != null) {
                    logger.log(Level.FINE, "JMS service '" + this.service.getName() + "' dropped response as request has no replyTo");
                }
                Message e = msg;
                return e;
            }
            if (msg.getOperation() != null) {
                String operationName = msg.getOperation().getName();
                if (this.jmsBinding.getEffectiveJMSPriority(operationName) != null) {
                    responseJMSMsg.setJMSPriority(this.jmsBinding.getEffectiveJMSPriority(operationName).intValue());
                }
                if (this.jmsBinding.getEffectiveJMSType(operationName) != null) {
                    responseJMSMsg.setJMSType(this.jmsBinding.getEffectiveJMSType(operationName));
                }
                if (this.jmsBinding.getEffectiveJMSDeliveryMode(operationName) != null) {
                    responseJMSMsg.setJMSDeliveryMode(this.jmsBinding.getEffectiveJMSDeliveryMode(operationName) != false ? 2 : 1);
                }
                if (this.jmsBinding.getEffectiveJMSTimeToLive(operationName) != null) {
                    responseJMSMsg.setJMSExpiration(this.jmsBinding.getEffectiveJMSTimeToLive(operationName).longValue());
                }
            }
            if (this.correlationScheme == null || "messageID".equalsIgnoreCase(this.correlationScheme)) {
                responseJMSMsg.setJMSCorrelationID(requestJMSMsg.getJMSMessageID());
            } else if ("correlationID".equalsIgnoreCase(this.correlationScheme)) {
                responseJMSMsg.setJMSCorrelationID(requestJMSMsg.getJMSCorrelationID());
            }
            MessageProducer producer = session.createProducer(replyDest);
            producer.setDeliveryMode(responseJMSMsg.getJMSDeliveryMode());
            producer.setPriority(responseJMSMsg.getJMSPriority());
            producer.setTimeToLive(responseJMSMsg.getJMSExpiration());
            producer.send((javax.jms.Message)msg.getBody());
            producer.close();
            Message message = msg;
            return message;
        }
        catch (JMSException e) {
            throw new JMSBindingException((Throwable)e);
        }
        finally {
            context.closeJmsResponseSession();
        }
    }

    public Invoker getNext() {
        return this.next;
    }

    public void setNext(Invoker next) {
        this.next = next;
    }

    public Message processRequest(Message msg) {
        return this.invokeRequest(msg);
    }

    public Message processResponse(Message msg) {
        JMSBindingContext context = (JMSBindingContext)msg.getBindingContext();
        try {
            Session session = context.getJmsResponseSession();
            javax.jms.Message responseJMSMsg = (javax.jms.Message)msg.getBody();
            Destination replyDest = context.getReplyToDestination();
            if (replyDest == null && this.jmsBinding.getResponseDestinationName() != null) {
                try {
                    replyDest = this.jmsResourceFactory.lookupDestination(this.jmsBinding.getResponseDestinationName());
                }
                catch (NamingException e) {
                    throw new JMSBindingException("Exception lookingup response destination", (Throwable)e);
                }
            }
            if (replyDest == null) {
                if (msg.getBody() != null) {
                    logger.log(Level.FINE, "JMS service '" + this.service.getName() + "' dropped response as request has no replyTo");
                }
                Message e = msg;
                return e;
            }
            if (msg.getOperation() != null) {
                String operationName = msg.getOperation().getName();
                if (this.jmsBinding.getEffectiveJMSPriority(operationName) != null) {
                    responseJMSMsg.setJMSPriority(this.jmsBinding.getEffectiveJMSPriority(operationName).intValue());
                }
                if (this.jmsBinding.getEffectiveJMSType(operationName) != null) {
                    responseJMSMsg.setJMSType(this.jmsBinding.getEffectiveJMSType(operationName));
                }
                if (this.jmsBinding.getEffectiveJMSDeliveryMode(operationName) != null) {
                    responseJMSMsg.setJMSDeliveryMode(this.jmsBinding.getEffectiveJMSDeliveryMode(operationName) != false ? 2 : 1);
                }
                if (this.jmsBinding.getEffectiveJMSTimeToLive(operationName) != null) {
                    responseJMSMsg.setJMSExpiration(this.jmsBinding.getEffectiveJMSTimeToLive(operationName).longValue());
                }
            }
            MessageProducer producer = session.createProducer(replyDest);
            producer.send((javax.jms.Message)msg.getBody());
            producer.close();
            Message message = msg;
            return message;
        }
        catch (JMSException e) {
            throw new JMSBindingException((Throwable)e);
        }
        finally {
            context.closeJmsResponseSession();
        }
    }
}

