/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.transport;

import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.NamingException;
import org.apache.tuscany.sca.binding.jms.JMSBinding;
import org.apache.tuscany.sca.binding.jms.JMSBindingException;
import org.apache.tuscany.sca.binding.jms.context.JMSBindingContext;
import org.apache.tuscany.sca.binding.jms.provider.JMSResourceFactory;
import org.apache.tuscany.sca.core.invocation.InterceptorAsyncImpl;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;

public class TransportReferenceInterceptor
extends InterceptorAsyncImpl {
    private Invoker next;
    private JMSResourceFactory jmsResourceFactory;
    private JMSBinding jmsBinding;

    public TransportReferenceInterceptor(JMSBinding jmsBinding, JMSResourceFactory jmsResourceFactory, RuntimeEndpointReference runtimeWire) {
        this.jmsBinding = jmsBinding;
        this.jmsResourceFactory = jmsResourceFactory;
    }

    public Message invoke(Message msg) {
        Message responseMsg = this.invokeRequest(msg);
        JMSBindingContext context = (JMSBindingContext)msg.getBindingContext();
        if (context.getReplyToDestination() == null || msg.getOperation().isNonBlocking()) {
            responseMsg.setBody(null);
        } else {
            responseMsg = this.invokeResponse(msg);
        }
        return responseMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message invokeRequest(Message msg) {
        try {
            Boolean deliveryModePersistent;
            Integer priority;
            JMSBindingContext context = (JMSBindingContext)msg.getBindingContext();
            Session session = context.getJmsSession();
            MessageProducer producer = session.createProducer(context.getRequestDestination());
            String opName = msg.getOperation().getName();
            if (this.jmsBinding.getEffectiveJMSTimeToLive(opName) != null) {
                producer.setTimeToLive(this.jmsBinding.getEffectiveJMSTimeToLive(msg.getOperation().getName()).longValue());
            }
            if ((priority = this.jmsBinding.getEffectiveJMSPriority(opName)) != null) {
                producer.setPriority(priority.intValue());
            }
            if ((deliveryModePersistent = this.jmsBinding.getEffectiveJMSDeliveryMode(opName)) != null) {
                producer.setDeliveryMode(deliveryModePersistent != false ? 2 : 1);
            }
            try {
                producer.send((javax.jms.Message)msg.getBody());
            }
            finally {
                producer.close();
            }
            return msg;
        }
        catch (JMSException e) {
            throw new JMSBindingException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message invokeResponse(Message msg) {
        JMSBindingContext context = (JMSBindingContext)msg.getBindingContext();
        try {
            javax.jms.Message replyMsg;
            Session session = context.getJmsResponseSession();
            javax.jms.Message requestMessage = (javax.jms.Message)msg.getBody();
            String msgSelector = null;
            String correlationScheme = this.jmsBinding.getCorrelationScheme();
            if (correlationScheme == null || "messageID".equalsIgnoreCase(correlationScheme)) {
                msgSelector = "JMSCorrelationID = '" + requestMessage.getJMSMessageID() + "'";
            } else if ("correlationID".equalsIgnoreCase(correlationScheme)) {
                msgSelector = "JMSCorrelationID = '" + requestMessage.getJMSCorrelationID() + "'";
            }
            MessageConsumer consumer = msgSelector != null ? session.createConsumer(context.getReplyToDestination(), msgSelector) : session.createConsumer(context.getReplyToDestination());
            try {
                context.getJmsResourceFactory().startConnection();
                replyMsg = consumer.receive(context.getTimeToLive());
            }
            finally {
                consumer.close();
            }
            if (replyMsg == null) {
                throw new JMSBindingException("No reply message received on " + context.getReplyToDestination() + " for message id " + requestMessage.getJMSMessageID());
            }
            msg.setBody((Object)replyMsg);
            Message message = msg;
            return message;
        }
        catch (JMSException e) {
            throw new JMSBindingException((Throwable)e);
        }
        catch (NamingException e) {
            throw new JMSBindingException((Throwable)e);
        }
        finally {
            try {
                context.closeJmsResponseSession();
                if (this.jmsResourceFactory.isConnectionClosedAfterUse()) {
                    this.jmsResourceFactory.closeResponseConnection();
                }
            }
            catch (JMSException e) {}
        }
    }

    public Invoker getNext() {
        return this.next;
    }

    public void setNext(Invoker next) {
        this.next = next;
    }

    public Message processRequest(Message tuscanyMsg) {
        return this.invokeRequest(tuscanyMsg);
    }

    public Message processResponse(Message tuscanyMsg) {
        return tuscanyMsg;
    }
}

