/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.provider.xml;

import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.tuscany.sca.binding.jms.provider.xml.XMLHelper;
import org.apache.tuscany.sca.common.xml.stax.StAXHelper;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.interfacedef.util.FaultException;

public class AXIOMXMLHelper
implements XMLHelper<OMElement> {
    private OMFactory factory;
    private StAXHelper staxhelper;

    public AXIOMXMLHelper(ExtensionPointRegistry epr) {
        this.staxhelper = StAXHelper.getInstance((ExtensionPointRegistry)epr);
        this.factory = OMAbstractFactory.getOMFactory();
    }

    @Override
    public OMElement load(String xml) throws IOException {
        StAXOMBuilder builder;
        try {
            builder = new StAXOMBuilder(this.staxhelper.createXMLStreamReader(xml));
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
        return builder.getDocumentElement();
    }

    @Override
    public String saveAsString(OMElement t) {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + t.toString();
    }

    @Override
    public String getOperationName(OMElement t) {
        return t.getLocalName();
    }

    @Override
    public Object wrap(OMElement template, OMElement os) {
        OMElement wrapper;
        if (os != null) {
            OMNamespace ns = os.declareNamespace(template.getNamespace().getNamespaceURI(), "");
            wrapper = this.factory.createOMElement(template.getLocalName(), ns);
            wrapper.addChild((OMNode)os);
        } else {
            wrapper = template.cloneOMElement();
        }
        return wrapper;
    }

    @Override
    public OMElement createWrapper(QName qname) {
        return this.factory.createOMElement(qname);
    }

    @Override
    public String getDataBindingName() {
        return OMElement.class.getName();
    }

    @Override
    public OMElement getFirstChild(OMElement o) {
        return o.getFirstElement();
    }

    @Override
    public void setFaultName(FaultException e, Object o) {
        OMElement om = (OMElement)o;
        e.setFaultName(new QName(om.getNamespace().getNamespaceURI(), om.getLocalName()));
    }
}

