/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.provider;

import java.io.IOException;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.apache.tuscany.sca.binding.jms.JMSBinding;
import org.apache.tuscany.sca.binding.jms.JMSBindingException;
import org.apache.tuscany.sca.binding.jms.provider.AbstractMessageProcessor;
import org.apache.tuscany.sca.binding.jms.provider.xml.XMLHelper;
import org.apache.tuscany.sca.binding.jms.provider.xml.XMLHelperFactory;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.interfacedef.util.FaultException;

public class XMLBytesMessageProcessor
extends AbstractMessageProcessor {
    private static final Logger logger = Logger.getLogger(XMLBytesMessageProcessor.class.getName());
    private XMLHelper xmlHelper;

    public XMLBytesMessageProcessor(JMSBinding jmsBinding, ExtensionPointRegistry registry) {
        super(jmsBinding);
        this.xmlHelper = XMLHelperFactory.createXMLHelper(registry);
    }

    @Override
    protected Object extractPayload(Message msg) {
        try {
            if (!(msg instanceof BytesMessage)) {
                throw new IllegalStateException("expecting JMS BytesMessage: " + msg);
            }
            long noOfBytes = ((BytesMessage)msg).getBodyLength();
            byte[] bytes = new byte[(int)noOfBytes];
            ((BytesMessage)msg).readBytes(bytes);
            ((BytesMessage)msg).reset();
            Object os = noOfBytes > 0L ? this.xmlHelper.load(new String(bytes)) : null;
            return os;
        }
        catch (JMSException e) {
            throw new JMSBindingException((Throwable)e);
        }
        catch (IOException e) {
            throw new JMSBindingException((Throwable)e);
        }
    }

    @Override
    public Object extractPayloadFromJMSMessage(Message msg) {
        if (msg instanceof BytesMessage) {
            return this.extractPayload(msg);
        }
        return super.extractPayloadFromJMSMessage(msg);
    }

    @Override
    protected Message createJMSMessage(Session session, Object o) {
        if (session == null) {
            logger.fine("no response session to create message: " + String.valueOf(o));
            return null;
        }
        try {
            BytesMessage message = session.createBytesMessage();
            if (o instanceof Object[]) {
                message.writeBytes(this.xmlHelper.saveAsString(((Object[])o)[0]).getBytes());
            } else if (o != null) {
                message.writeBytes(this.xmlHelper.saveAsString(o).getBytes());
            }
            return message;
        }
        catch (JMSException e) {
            throw new JMSBindingException((Throwable)e);
        }
    }

    @Override
    public Message createFaultMessage(Session session, Throwable o) {
        if (session == null) {
            logger.fine("no response session to create fault message: " + String.valueOf(o));
            return null;
        }
        if (o instanceof FaultException) {
            try {
                BytesMessage message = session.createBytesMessage();
                message.writeBytes(this.xmlHelper.saveAsString(((FaultException)o).getFaultInfo()).getBytes());
                message.setBooleanProperty("org_apache_tuscany_sca_fault", true);
                return message;
            }
            catch (JMSException e) {
                throw new JMSBindingException((Throwable)e);
            }
        }
        return super.createFaultMessage(session, o);
    }
}

