/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.provider;

import java.util.logging.Logger;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.binding.jms.JMSBinding;
import org.apache.tuscany.sca.binding.jms.JMSBindingException;
import org.apache.tuscany.sca.binding.jms.headers.HeaderServiceInterceptor;
import org.apache.tuscany.sca.binding.jms.host.JMSServiceListener;
import org.apache.tuscany.sca.binding.jms.host.JMSServiceListenerDetails;
import org.apache.tuscany.sca.binding.jms.host.JMSServiceListenerFactory;
import org.apache.tuscany.sca.binding.jms.provider.JMSBindingAsyncResponseInvoker;
import org.apache.tuscany.sca.binding.jms.provider.JMSResourceFactory;
import org.apache.tuscany.sca.binding.jms.transport.TransportServiceInterceptor;
import org.apache.tuscany.sca.binding.jms.wire.AsyncResponseDestinationInterceptor;
import org.apache.tuscany.sca.binding.jms.wire.CallbackDestinationInterceptor;
import org.apache.tuscany.sca.binding.jms.wire.OperationPropertiesInterceptor;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.invocation.InvokerAsyncResponse;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.provider.EndpointAsyncProvider;
import org.apache.tuscany.sca.provider.OperationSelectorProvider;
import org.apache.tuscany.sca.provider.OperationSelectorProviderFactory;
import org.apache.tuscany.sca.provider.ProviderFactoryExtensionPoint;
import org.apache.tuscany.sca.provider.WireFormatProvider;
import org.apache.tuscany.sca.provider.WireFormatProviderFactory;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;

public class JMSBindingServiceBindingProvider
implements EndpointAsyncProvider,
JMSServiceListenerDetails {
    private static final Logger logger = Logger.getLogger(JMSBindingServiceBindingProvider.class.getName());
    protected ExtensionPointRegistry registry;
    protected RuntimeEndpoint endpoint;
    protected RuntimeComponentService service;
    protected Binding targetBinding;
    protected JMSBinding jmsBinding;
    protected JMSResourceFactory jmsResourceFactory;
    protected JMSServiceListenerFactory serviceListenerFactory;
    protected JMSServiceListener serviceListener;
    protected RuntimeComponent component;
    protected InterfaceContract interfaceContract;
    protected ProviderFactoryExtensionPoint providerFactories;
    protected FactoryExtensionPoint modelFactories;
    protected MessageFactory messageFactory;
    protected OperationSelectorProviderFactory operationSelectorProviderFactory;
    protected OperationSelectorProvider operationSelectorProvider;
    protected WireFormatProviderFactory requestWireFormatProviderFactory;
    protected WireFormatProvider requestWireFormatProvider;
    protected WireFormatProviderFactory responseWireFormatProviderFactory;
    protected WireFormatProvider responseWireFormatProvider;

    public JMSBindingServiceBindingProvider(ExtensionPointRegistry registry, RuntimeEndpoint endpoint, JMSServiceListenerFactory serviceListenerFactory, ExtensionPointRegistry extensionPoints, JMSResourceFactory jmsResourceFactory) {
        this.endpoint = endpoint;
        this.component = (RuntimeComponent)endpoint.getComponent();
        this.service = (RuntimeComponentService)endpoint.getService();
        this.jmsBinding = (JMSBinding)endpoint.getBinding();
        this.serviceListenerFactory = serviceListenerFactory;
        this.targetBinding = this.jmsBinding;
        this.jmsResourceFactory = jmsResourceFactory;
        this.registry = registry;
        if (this.jmsBinding.getResponseActivationSpecName() != null && this.jmsBinding.getResponseActivationSpecName().length() > 0) {
            throw new JMSBindingException("[BJM30023] response/activationSpec element MUST NOT be present when the binding is being used for an SCA service");
        }
        this.initBindingName();
        this.modelFactories = (FactoryExtensionPoint)extensionPoints.getExtensionPoint(FactoryExtensionPoint.class);
        this.messageFactory = (MessageFactory)this.modelFactories.getFactory(MessageFactory.class);
        this.providerFactories = (ProviderFactoryExtensionPoint)extensionPoints.getExtensionPoint(ProviderFactoryExtensionPoint.class);
        this.operationSelectorProviderFactory = (OperationSelectorProviderFactory)this.providerFactories.getProviderFactory(this.jmsBinding.getOperationSelector().getClass());
        if (this.operationSelectorProviderFactory != null) {
            this.operationSelectorProvider = this.operationSelectorProviderFactory.createServiceOperationSelectorProvider(endpoint);
        }
        this.requestWireFormatProviderFactory = (WireFormatProviderFactory)this.providerFactories.getProviderFactory(this.jmsBinding.getRequestWireFormat().getClass());
        if (this.requestWireFormatProviderFactory != null) {
            this.requestWireFormatProvider = this.requestWireFormatProviderFactory.createServiceWireFormatProvider(endpoint);
        }
        this.responseWireFormatProviderFactory = (WireFormatProviderFactory)this.providerFactories.getProviderFactory(this.jmsBinding.getResponseWireFormat().getClass());
        if (this.responseWireFormatProviderFactory != null) {
            this.responseWireFormatProvider = this.responseWireFormatProviderFactory.createServiceWireFormatProvider(endpoint);
        }
        try {
            this.interfaceContract = (InterfaceContract)this.service.getInterfaceContract().clone();
            this.requestWireFormatProvider.configureWireFormatInterfaceContract(this.interfaceContract);
            this.responseWireFormatProvider.configureWireFormatInterfaceContract(this.interfaceContract);
        }
        catch (CloneNotSupportedException ex) {
            this.interfaceContract = this.service.getInterfaceContract();
        }
    }

    protected void initBindingName() {
        if (this.jmsBinding.getDestinationName() == null && (this.jmsBinding.getActivationSpecName() == null || this.jmsBinding.getActivationSpecName().equals(""))) {
            this.jmsBinding.setDestinationName(this.service.getName());
        }
    }

    public InterfaceContract getBindingInterfaceContract() {
        return this.interfaceContract;
    }

    public boolean supportsOneWayInvocation() {
        return true;
    }

    public void start() {
        try {
            this.serviceListener = this.serviceListenerFactory.createJMSServiceListener(this);
            this.serviceListener.start();
        }
        catch (Exception e) {
            if (e instanceof JMSBindingException) {
                throw (JMSBindingException)e;
            }
            throw new JMSBindingException("Error starting JMSServiceBinding", (Throwable)e);
        }
    }

    public void stop() {
        try {
            this.serviceListener.stop();
        }
        catch (Exception e) {
            if (e instanceof JMSBindingException) {
                throw (JMSBindingException)e;
            }
            throw new JMSBindingException("Error stopping JMSServiceBinding", (Throwable)e);
        }
    }

    public String getDestinationName() {
        return this.serviceListener.getDestinationName();
    }

    public void configure() {
        InvocationChain bindingChain = this.endpoint.getBindingInvocationChain();
        bindingChain.addInterceptor("service.binding.transport", (Interceptor)new TransportServiceInterceptor(this.registry, this.jmsBinding, this.jmsResourceFactory, this.endpoint));
        bindingChain.addInterceptor(this.operationSelectorProvider.getPhase(), this.operationSelectorProvider.createInterceptor());
        bindingChain.addInterceptor("service.binding.operationselector", (Interceptor)new OperationPropertiesInterceptor(this.jmsBinding, this.endpoint));
        bindingChain.addInterceptor("service.binding.wireformat", (Interceptor)new CallbackDestinationInterceptor(this.endpoint));
        bindingChain.addInterceptor("service.binding.wireformat", (Interceptor)new HeaderServiceInterceptor(this.registry, this.jmsBinding));
        bindingChain.addInterceptor("service.binding.wireformat", (Interceptor)new AsyncResponseDestinationInterceptor(this.endpoint, this.registry));
        bindingChain.addInterceptor(this.requestWireFormatProvider.getPhase(), this.requestWireFormatProvider.createInterceptor());
        if (!this.jmsBinding.getRequestWireFormat().equals(this.jmsBinding.getResponseWireFormat())) {
            bindingChain.addInterceptor(this.responseWireFormatProvider.getPhase(), this.responseWireFormatProvider.createInterceptor());
        }
    }

    public RuntimeComponent getComponent() {
        return this.component;
    }

    public RuntimeComponentService getService() {
        return this.service;
    }

    @Override
    public Binding getTargetBinding() {
        return this.targetBinding;
    }

    @Override
    public JMSBinding getJmsBinding() {
        return this.jmsBinding;
    }

    @Override
    public MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    public JMSResourceFactory getResourceFactory() {
        return this.jmsResourceFactory;
    }

    @Override
    public RuntimeEndpoint getEndpoint() {
        return this.endpoint;
    }

    public boolean supportsNativeAsync() {
        return true;
    }

    public InvokerAsyncResponse createAsyncResponseInvoker() {
        return new JMSBindingAsyncResponseInvoker(null, this.endpoint);
    }
}

