/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.provider;

import javax.jms.JMSException;
import javax.naming.NamingException;
import org.apache.tuscany.sca.binding.jms.JMSBinding;
import org.apache.tuscany.sca.binding.jms.JMSBindingException;
import org.apache.tuscany.sca.binding.jms.headers.HeaderReferenceInterceptor;
import org.apache.tuscany.sca.binding.jms.host.AsyncResponseJMSServiceListener;
import org.apache.tuscany.sca.binding.jms.host.JMSAsyncResponseInvoker;
import org.apache.tuscany.sca.binding.jms.provider.JMSResourceFactory;
import org.apache.tuscany.sca.binding.jms.provider.RRBJMSBindingInvoker;
import org.apache.tuscany.sca.binding.jms.transport.TransportReferenceInterceptor;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.provider.EndpointReferenceAsyncProvider;
import org.apache.tuscany.sca.provider.ProviderFactoryExtensionPoint;
import org.apache.tuscany.sca.provider.WireFormatProvider;
import org.apache.tuscany.sca.provider.WireFormatProviderFactory;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;
import org.apache.tuscany.sca.work.WorkScheduler;

public class JMSBindingReferenceBindingProvider
implements EndpointReferenceAsyncProvider {
    protected RuntimeEndpointReference endpointReference;
    protected RuntimeComponentReference reference;
    protected JMSBinding jmsBinding;
    protected JMSResourceFactory jmsResourceFactory;
    protected InterfaceContract interfaceContract;
    protected ExtensionPointRegistry extensions;
    protected ProviderFactoryExtensionPoint providerFactories;
    protected WireFormatProviderFactory requestWireFormatProviderFactory;
    protected WireFormatProvider requestWireFormatProvider;
    protected WireFormatProviderFactory responseWireFormatProviderFactory;
    protected WireFormatProvider responseWireFormatProvider;
    protected AsyncResponseJMSServiceListener responseQueue = null;

    public JMSBindingReferenceBindingProvider(RuntimeEndpointReference endpointReference, ExtensionPointRegistry extensions, JMSResourceFactory jmsResourceFactory) {
        this.endpointReference = endpointReference;
        this.reference = (RuntimeComponentReference)endpointReference.getReference();
        this.jmsBinding = (JMSBinding)endpointReference.getBinding();
        this.extensions = extensions;
        this.jmsResourceFactory = jmsResourceFactory;
        this.providerFactories = (ProviderFactoryExtensionPoint)extensions.getExtensionPoint(ProviderFactoryExtensionPoint.class);
        this.requestWireFormatProviderFactory = (WireFormatProviderFactory)this.providerFactories.getProviderFactory(this.jmsBinding.getRequestWireFormat().getClass());
        if (this.requestWireFormatProviderFactory != null) {
            this.requestWireFormatProvider = this.requestWireFormatProviderFactory.createReferenceWireFormatProvider(endpointReference);
        }
        this.responseWireFormatProviderFactory = (WireFormatProviderFactory)this.providerFactories.getProviderFactory(this.jmsBinding.getResponseWireFormat().getClass());
        if (this.responseWireFormatProviderFactory != null) {
            this.responseWireFormatProvider = this.responseWireFormatProviderFactory.createReferenceWireFormatProvider(endpointReference);
        }
        try {
            this.interfaceContract = (InterfaceContract)this.reference.getInterfaceContract().clone();
            this.requestWireFormatProvider.configureWireFormatInterfaceContract(this.interfaceContract);
            this.responseWireFormatProvider.configureWireFormatInterfaceContract(this.interfaceContract);
        }
        catch (CloneNotSupportedException ex) {
            this.interfaceContract = this.reference.getInterfaceContract();
        }
        if (endpointReference.isAsyncInvocation()) {
            String asyncCallbackName = endpointReference.getReference().getName() + "_asyncResponse";
            this.jmsBinding.setResponseDestinationName(asyncCallbackName);
        }
    }

    public Invoker createInvoker(Operation operation) {
        if (this.jmsBinding.getDestinationName() == null) {
            throw new JMSBindingException("No destination specified for reference " + this.reference.getName());
        }
        if (this.jmsBinding.getActivationSpecName() != null) {
            throw new JMSBindingException("Activation spec can not be specified on an SCA reference binding.");
        }
        RRBJMSBindingInvoker invoker = null;
        invoker = new RRBJMSBindingInvoker(operation, this.jmsResourceFactory, this.endpointReference);
        return invoker;
    }

    public boolean supportsOneWayInvocation() {
        return true;
    }

    public InterfaceContract getBindingInterfaceContract() {
        return this.interfaceContract;
    }

    public void start() {
        if (this.endpointReference.isAsyncInvocation()) {
            JMSAsyncResponseInvoker listener;
            FactoryExtensionPoint modelFactories = (FactoryExtensionPoint)this.extensions.getExtensionPoint(FactoryExtensionPoint.class);
            MessageFactory messageFactory = (MessageFactory)modelFactories.getFactory(MessageFactory.class);
            try {
                listener = new JMSAsyncResponseInvoker(this.endpointReference, messageFactory, this.jmsResourceFactory);
            }
            catch (NamingException e) {
                throw new JMSBindingException("Unable to create JMSResponseInvoker", (Throwable)e);
            }
            UtilityExtensionPoint utilities = (UtilityExtensionPoint)this.extensions.getExtensionPoint(UtilityExtensionPoint.class);
            WorkScheduler workScheduler = (WorkScheduler)utilities.getUtility(WorkScheduler.class);
            this.responseQueue = new AsyncResponseJMSServiceListener(listener, this.jmsBinding.getResponseDestinationName(), this.jmsBinding, workScheduler, this.jmsResourceFactory);
            this.responseQueue.start();
        }
    }

    public void stop() {
        try {
            if (this.responseQueue != null) {
                this.responseQueue.stop();
            }
            this.jmsResourceFactory.closeConnection();
            this.jmsResourceFactory.closeResponseConnection();
        }
        catch (JMSException e) {
            throw new JMSBindingException((Throwable)e);
        }
    }

    public void configure() {
        InvocationChain bindingChain = this.endpointReference.getBindingInvocationChain();
        bindingChain.addInterceptor("reference.binding.transport", (Interceptor)new TransportReferenceInterceptor(this.jmsBinding, this.jmsResourceFactory, this.endpointReference));
        bindingChain.addInterceptor(this.requestWireFormatProvider.getPhase(), this.requestWireFormatProvider.createInterceptor());
        if (!this.jmsBinding.getRequestWireFormat().equals(this.jmsBinding.getResponseWireFormat())) {
            bindingChain.addInterceptor(this.responseWireFormatProvider.getPhase(), this.responseWireFormatProvider.createInterceptor());
        }
        bindingChain.addInterceptor("reference.binding.wireformat", (Interceptor)new HeaderReferenceInterceptor(this.extensions, this.jmsBinding, this.jmsResourceFactory, this.endpointReference));
    }

    public boolean supportsNativeAsync() {
        return true;
    }

    public JMSResourceFactory getJMSResourceFactory() {
        return this.jmsResourceFactory;
    }
}

