/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.policy.header.provider;

import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.binding.jms.context.JMSBindingContext;
import org.apache.tuscany.sca.binding.jms.policy.header.JMSHeaderPolicy;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.invocation.PhasedInterceptor;
import org.apache.tuscany.sca.policy.PolicyExpression;
import org.apache.tuscany.sca.policy.PolicySet;

public class JMSHeaderReferencePolicyInterceptor
implements PhasedInterceptor {
    private Invoker next;
    private PolicySet policySet = null;
    private String context;
    private JMSHeaderPolicy jmsHeaderPolicy;
    private String phase;
    private EndpointReference endpointReference;

    public JMSHeaderReferencePolicyInterceptor(String context, EndpointReference endpointReference, PolicySet policySet, String phase) {
        this.endpointReference = endpointReference;
        this.policySet = policySet;
        this.context = context;
        this.phase = phase;
        this.init();
    }

    private void init() {
        if (this.policySet != null) {
            for (PolicyExpression policyObject : this.policySet.getPolicies()) {
                if (!(policyObject instanceof JMSHeaderPolicy)) continue;
                this.jmsHeaderPolicy = (JMSHeaderPolicy)policyObject;
                break;
            }
        }
    }

    public Message invoke(Message msg) {
        JMSBindingContext context = (JMSBindingContext)msg.getBindingContext();
        javax.jms.Message jmsMsg = (javax.jms.Message)msg.getBody();
        return this.getNext().invoke(msg);
    }

    public Invoker getNext() {
        return this.next;
    }

    public void setNext(Invoker next) {
        this.next = next;
    }

    public String getPhase() {
        return this.phase;
    }
}

