/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.operationselector.jmsuserprop.runtime;

import java.util.List;
import javax.jms.JMSException;
import org.apache.tuscany.sca.binding.jms.JMSBinding;
import org.apache.tuscany.sca.binding.jms.JMSBindingException;
import org.apache.tuscany.sca.binding.jms.context.JMSBindingContext;
import org.apache.tuscany.sca.binding.jms.operationselector.OperationSelectorJMSUserProp;
import org.apache.tuscany.sca.core.invocation.InterceptorAsyncImpl;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;

public class OperationSelectorJMSUserPropServiceInterceptor
extends InterceptorAsyncImpl {
    private Invoker next;
    private RuntimeEndpoint endpoint;
    private JMSBinding jmsBinding;
    private OperationSelectorJMSUserProp operationSelector;
    private RuntimeComponentService service;
    private List<Operation> serviceOperations;

    public OperationSelectorJMSUserPropServiceInterceptor(RuntimeEndpoint endpoint) {
        this.jmsBinding = (JMSBinding)endpoint.getBinding();
        this.operationSelector = (OperationSelectorJMSUserProp)this.jmsBinding.getOperationSelector();
        this.endpoint = endpoint;
        this.service = (RuntimeComponentService)endpoint.getService();
        this.serviceOperations = this.service.getInterfaceContract().getInterface().getOperations();
    }

    public Message invoke(Message msg) {
        return this.next.invoke(this.invokeRequest(msg));
    }

    public Message invokeRequest(Message msg) {
        JMSBindingContext context = (JMSBindingContext)msg.getBindingContext();
        javax.jms.Message jmsMsg = context.getJmsMsg();
        Operation operation = this.getTargetOperation(jmsMsg);
        msg.setOperation(operation);
        return msg;
    }

    protected Operation getTargetOperation(javax.jms.Message jmsMsg) {
        String operationName = null;
        String opSelectorPropertyName = this.operationSelector.getPropertyName();
        try {
            operationName = jmsMsg.getStringProperty(opSelectorPropertyName);
        }
        catch (JMSException e) {
            throw new JMSBindingException((Throwable)e);
        }
        if (operationName == null) {
            throw new JMSBindingException("Property " + opSelectorPropertyName + " not found in message header");
        }
        for (Operation op : this.serviceOperations) {
            if (!op.getName().equals(operationName)) continue;
            return op;
        }
        throw new JMSBindingException("Can't find operation " + operationName);
    }

    public Invoker getNext() {
        return this.next;
    }

    public void setNext(Invoker next) {
        this.next = next;
    }

    public Message processRequest(Message msg) {
        return this.invokeRequest(msg);
    }

    public Message processResponse(Message msg) {
        return msg;
    }
}

